<x-guest-layout>

    @section('title')
        {{ __('Reset Password') }}
    @endsection

    <div class="row align-items-center justify-content-center vh-100">
        <div class="card col-11 col-sm-8 col-md-6 col-lg-5 col-xl-4 col-xxl-3 py-6">

            <div class="d-flex justify-content-center mb-4">
                <img class="w-50" src="{{ get_logo_sistema() }}" alt="logo">
            </div>

            <!-- Title -->
            <h1 class="mb-2 text-center">
                {{ __('Forgot your password?') }}
            </h1>

            @if (session('status'))
                <div class="mb-4 text-success">
                    {{ session('status') }}
                </div>
            @endif

            <x-validation-errors class="mb-4" />

            <!-- Form -->
            <form method="POST" class="mt-4" action="{{ route('password.update') }}">
                @csrf

                <input type="hidden" name="token" value="{{ $request->route('token') }}">

                <div class="row">
                    <div class="col-12">
                        <div>

                            <!-- Label -->
                            <label class="form-label">
                                {{ __('Email Address') }}
                            </label>

                            <!-- Input -->
                            <input type="email" class="form-control" id="email" name="email" :value="old('email', $request->email)" required autofocus autocomplete="email" placeholder="{{ __('Enter your email address') }}">
                        </div>
                    </div>
                </div> <!-- / .row -->

                <div class="row">

                    <div class="col-12">
                        <div>
                            <label for="password" class="col-form-label">{{ __('New Password') }}</label>
                            <div class="input-group input-group-merge">
                                <input type="password" id="password" class="form-control" name="password" autocomplete="new-password" data-toggle-password-input placeholder="{{ __('Your New Password') }}">
                                <button type="button" class="input-group-text px-4 text-secondary link-primary" data-toggle-password></button>
                            </div>
                            <small class="text-danger">
                                @error('password')
                                    {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>

                    <div class="col-12">
                        <div>
                            <label for="password_confirmation" class="col-form-label">{{ __('Confirm Password') }}</label>
                            <div class="input-group input-group-merge">
                                <input type="password" id="password_confirmation" class="form-control" name="password_confirmation" autocomplete="new-password" data-toggle-password-input placeholder="{{ __('Your New Password') }}">
                                <button type="button" class="input-group-text px-4 text-secondary link-primary" data-toggle-password></button>
                            </div>
                            <small class="text-danger">
                                @error('password')
                                    {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>

                </div> <!-- / .row -->

                <div class="row align-items-center text-center">
                    <div class="col-12">

                        <!-- Button -->
                        <button type="submit"
                            class="btn w-100 btn-primary mt-3 mb-2">{{ __('Reset Password') }}</button>
                    </div>
                </div> <!-- / .row -->
            </form>
        </div>
    </div> <!-- / .row -->
</x-guest-layout>
