<x-app-layout>

    <div>
        <div class="col" x-data="{
            tipoCliente: '{{ $tipoCliente }}',
            changeForm(tipoCliente) {
                this.tipoCliente = tipoCliente;
            }
        }">
            <ul class="nav nav-pills nav-fill">
                <li class="nav-item">
                    <button class="nav-link"
                        :class="tipoCliente == '{{ $TipoClientes::EMPRESA->getName() }}' ? 'active' : ''"
                        x-bind:aria-current="tipoCliente == '{{ $TipoClientes::EMPRESA->getName() }}' ? 'page' : ''"
                        @click="changeForm('{{ $TipoClientes::EMPRESA->getName() }}')">
                        Empresa
                    </button>
                </li>
                <li class="nav-item">
                    <button class="nav-link"
                        :class="tipoCliente == '{{ $TipoClientes::PERSONA->getName() }}' ? 'active' : ''"
                        x-bind:aria-current="tipoCliente == '{{ $TipoClientes::PERSONA->getName() }}' ? 'page' : ''"
                        @click="changeForm('{{ $TipoClientes::PERSONA->getName() }}')">
                        Persona
                    </button>
                </li>
            </ul>
            <div x-cloak x-show="tipoCliente == '{{ $TipoClientes::EMPRESA->getName() }}'">
                @livewire("cliente.cliente-empresa-form-component")
            </div>
            <div x-cloak x-show="tipoCliente == '{{ $TipoClientes::PERSONA->getName() }}'">
                @livewire("cliente.cliente-persona-form-component")
            </div>
        </div>
    </div>
</x-app-layout>