@php
use App\Models\Cobranza;


$totalCobrosParticualesPendientes = Cobranza::montoCobrosParticularesPendiente();
$totalCobrosMensualidadesPendientes = Cobranza::montoCobrosMensualidadesPendiente();
$totalCobrosMensualidadesNDiasProximosPendientes = Cobranza::montoCobrosMensualidadesProximosNdias(7);
@endphp


<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" data-theme="auto" data-sidebar-behaviour="fixed"
    data-navigation-color="inverted" data-is-fluid="true">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    {{-- Font awesome --}}
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.1/css/all.min.css" rel="stylesheet">


    <!-- Theme CSS -->
    <link rel="stylesheet" href="{{ asset('assets/css/theme.bundle.css') }}">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preload" as="style"
        href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700;800&display=swap">
    <link rel="stylesheet" media="print" onload="this.onload=null;this.removeAttribute('media');"
        href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700;800&display=swap">
    @include('sweetalert::alert')


    <title>{{ config('app.name', 'Laravel') }} - @yield('title') </title>

    <!-- no-JS fallback -->
    <noscript>
        <link rel="stylesheet"
            href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700;800&display=swap">
    </noscript>

    <script>
        // Theme switcher
        let themeSwitcher = document.getElementById('themeSwitcher');

        const getPreferredTheme = () => {
            if (localStorage.getItem('theme') != null) {
                return localStorage.getItem('theme');
            }

            return document.documentElement.dataset.theme;
        };

        const setTheme = function(theme) {
            if (theme === 'auto' && window.matchMedia('(prefers-color-scheme: dark)').matches) {
                document.documentElement.dataset.theme = window.matchMedia('(prefers-color-scheme: dark)').matches ?
                    'dark' : 'light';
            } else {
                document.documentElement.dataset.theme = theme;
            }

            localStorage.setItem('theme', theme);
        };

        const showActiveTheme = theme => {
            const activeBtn = document.querySelector(`[data-theme-value="${theme}"]`);

            document.querySelectorAll('[data-theme-value]').forEach(element => {
                element.classList.remove('active');
            });

            activeBtn && activeBtn.classList.add('active');

            // Set button if demo mode is enabled
            document.querySelectorAll('[data-theme-control="theme"]').forEach(element => {
                if (element.value == theme) {
                    element.checked = true;
                }
            });
        };

        function reloadPage() {
            window.location = window.location.pathname;
        }


        setTheme(getPreferredTheme());

        if (typeof themeSwitcher != 'undefined') {
            window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
                if (localStorage.getItem('theme') != null) {
                    if (localStorage.getItem('theme') == 'auto') {
                        reloadPage();
                    }
                }
            });

            window.addEventListener('load', () => {
                showActiveTheme(getPreferredTheme());

                document.querySelectorAll('[data-theme-value]').forEach(element => {
                    element.addEventListener('click', () => {
                        const theme = element.getAttribute('data-theme-value');

                        localStorage.setItem('theme', theme);
                        reloadPage();
                    })
                })
            });
        }
    </script>
    <!-- Favicon -->
    <link rel="icon" href="{{ asset('assets/favicon/favicon.png') }}" sizes="any">

    {{-- Datatables --}}
    <link rel="stylesheet" src="{{asset('assets/css/datatables.min.css')}}">
    </link>
    <script src="{{asset('assets/js/jquery.min.js')}}"></script>
    <script src="{{asset('assets/js/datatables.min.js')}}"></script>
    @livewireStyles
</head>


<body>

    <!-- THEME CONFIGURATION -->
    {{-- <script>
        let themeAttrs = document.documentElement.dataset;

        for (let attr in themeAttrs) {
            if (localStorage.getItem(attr) != null) {
                document.documentElement.dataset[attr] = localStorage.getItem(attr);

                if (theme === 'auto') {
                    document.documentElement.dataset.theme = window.matchMedia('(prefers-color-scheme: dark)').matches ?
                        'dark' : 'light';

                    window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
                        e.matches ? document.documentElement.dataset.theme = 'dark' : document.documentElement
                            .dataset.theme = 'light';
                    });
                }
            }
        }
    </script> --}}

    @include('layouts.sidebar.index')

    <main>
        <x-navbar>

            @stack('search')

            <x-slot name="top">
                <div class="d-flex align-items-center ms-auto me-n1 me-lg-n2">

                    <div class="vr bg-gray-700 mx-2 mx-lg-3"></div>
                    <div class="text-muted text-center">
                        <div class="row">
                            <span class="col-12">
                                $@money($totalCobrosParticualesPendientes)
                            </span>
                        </div>
                        <div class="row">
                            <span class="fs-6">
                                CXC Particulares

                            </span>
                        </div>
                    </div>

                    <div class="vr bg-gray-700 mx-2 mx-lg-3"></div>
                    <div class="text-muted text-center">
                        <div class="row">
                            <span class="col-12">
                                $@money($totalCobrosMensualidadesNDiasProximosPendientes)
                            </span>
                        </div>
                        <div class="row">
                            <span class="fs-6">
                                Cobros por mensualidad (7 dias)
                            </span>
                        </div>
                    </div>

                    <div class="vr bg-gray-700 mx-2 mx-lg-3"></div>
                    <div class="text-muted text-center">
                        <div class="row">
                            <span class="col-12">
                                $@money($totalCobrosMensualidadesPendientes)
                            </span>
                        </div>
                        <div class="row">
                            <span class="fs-6">
                                Cobros por mensualidad
                            </span>
                        </div>
                    </div>
                    <div class="vr bg-gray-700 mx-2 mx-lg-3"></div>

                    <!-- Dropdown -->
                    <x-navbar.items.theme-switcher />

                    <!-- Separator -->
                    <div class="vr bg-gray-700 mx-2 mx-lg-3"></div>

                    {{--
                    <x-navbar.items.notification /> --}}

                    <!-- Separator -->
                    <div class="vr bg-gray-700 mx-2 mx-lg-3"></div>

                    <!-- Dropdown -->
                    <div class="dropdown">
                        <a href="javascript: void(0);"
                            class="dropdown-toggle no-arrow d-flex align-items-center justify-content-center bg-white rounded-circle shadow-sm mx-1 mx-lg-2 w-40px h-40px"
                            role="button" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-haspopup="true"
                            aria-expanded="false" data-bs-offset="0,0">
                            <div class="avatar avatar-circle avatar-sm avatar-online">
                                <img src="{{ auth()->user()->profile_photo_url }}" alt="profile photo"
                                    class="avatar-img" width="40" height="40">
                            </div>
                        </a>

                        <div class="dropdown-menu">
                            <div class="dropdown-item-text">
                                <div class="d-flex align-items-center">
                                    <div class="avatar avatar-sm avatar-circle">
                                        <img src="{{ auth()->user()->profile_photo_url }}" alt="profile photo"
                                            class="avatar-img" width="40" height="40">
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <h4 class="mb-0">{{ auth()->user()->name }}</h4>
                                        <p class="card-text">{{ auth()->user()->email }}</p>
                                    </div>
                                </div>
                            </div>

                            <hr class="dropdown-divider">

                            <a class="dropdown-item" href="{{ route('user.profile', auth()->user()->uuid) }}">Perfil</a>

                            <hr class="dropdown-divider">
                            <form method="POST" action="{{ route('logout') }}">
                                @csrf
                                <a class="dropdown-item" href="{{ route('logout') }}"
                                    onclick="event.preventDefault(); this.closest('form').submit();">
                                    {{ __('Sign Out') }}
                                </a>
                            </form>

                        </div>
                    </div>
                </div>
            </x-slot>

        </x-navbar>

        <div class="container-fluid">
            {{ $slot }}
        </div> <!-- / .container-fluid -->
    </main>


    <footer class="mt-auto">
        <div class="container-fluid mt-4 mb-6 text-muted">
            <div class="row justify-content-between">
                <div class="col">
                    © Dashly. {{ date('Y') }}.
                </div>

                <div class="col-auto">
                    v1.4.0
                </div>
            </div> <!-- / .row -->
        </div>
    </footer>
    {{-- scripts --}}
    {{-- <script src="{{ asset('assets/js/theme.bundle.js') }}"></script> --}}
    @stack('scripts')

    @livewireScripts
    <x-livewire-alert::scripts />


    <script>
        $(document).ready(function () {
            var dataTableConfig = {
                // "order": [[2, "desc"]],
                "ordering": false, // Desactiva el ordenamiento por defecto

                "pageLength": 50,
                "language": {
                    "sProcessing": "Procesando...",
                    "sLengthMenu": "Mostrar _MENU_ registros",
                    "sZeroRecords": "No se encontraron resultados",
                    "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
                    "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
                    "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
                    "sSearch": "Buscar:",
                    "sEmptyTable": "No hay datos disponibles en la tabla",
                    "sLoadingRecords": "Cargando...",
                    "oPaginate": {
                        "sFirst": "Primero",
                        "sLast": "Último",
                        "sNext": "Siguiente",
                        "sPrevious": "Anterior"
                    },
                    "oAria": {
                        "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
                        "sSortDescending": ": Activar para ordenar la columna de manera descendente"
                    }
                }
            };

            // Inicializar DataTable con la configuración guardada en la variable
            $('.datatable').DataTable(dataTableConfig);
        });
    </script>
</body>

</html>
