@php
$planes_route = 'planes.index';
$remotas_route = 'remotas.index';

$entidades = ['planes', 'remotas'];

$menu_remotas_routes = [$planes_route, $remotas_route];
@endphp
<li class="nav-item dropdown">
    <a @class([ 'nav-link' , 'active'=> Str::contains(Route::currentRouteName(), $entidades)]) href="#remotaCollapse"
        data-bs-toggle="collapse" role="button"
        aria-controls="remotaCollapse">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="nav-link-icon" height="18" width="18">
            <path class="a" d="M11.266,15.23a3.75,3.75,0,1,1,3.75-3.75Z" fill="none" stroke="currentColor"
                stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
            <rect class="a" x="15.16" y="1.379" width="6" height="6" rx="1.5" ry="1.5"
                transform="translate(2.223 14.124) rotate(-45)" />
            <rect class="a" x="1.371" y="15.374" width="6" height="6" rx="1.5" ry="1.5"
                transform="translate(-11.712 8.473) rotate(-45)" />
            <line class="a" x1="7.023" y1="7.237" x2="8.614" y2="8.828" />
            <path class="a" d="M16.969,13.763a5.265,5.265,0,0,1-3.188,3.194" fill="none" stroke="currentColor"
                stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
            <path class="a" d="M20.15,13.413a8.256,8.256,0,0,1-6.729,6.728" fill="none" stroke="currentColor"
                stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
            <path class="a" d="M23.25,12.664A11.25,11.25,0,0,1,12.5,23.25" fill="none" stroke="currentColor"
                stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
        </svg>
        <span>Remota Satelital</span>
    </a>
    <div class="{{Str::contains(Route::currentRouteName(), $entidades) ? 'collapse show' : 'collapse' }}"
        id="remotaCollapse">
        <ul class="nav flex-column">
            <li class="nav-item">
                <a href="{{ route($planes_route) }}" @class(['nav-link', 'active'=>
                    Str::contains(Route::currentRouteName(), 'planes')])>
                    <span>Planes</span>
                </a>
            </li>
            @can('remotas_satelital.index')
            <li class="nav-item">
                <a href="{{ route($remotas_route) }}"
                    @class(['nav-link', 'active'=>Str::contains(Route::currentRouteName(), 'remotas')])>
                    <span>Remotas</span>
                </a>
            </li>
            @endcan

        </ul>
    </div>
</li>