<div>
    @section('title', $pageTitle)
    <div class="col">
        <x-persona.form pageTitle="{{ $pageTitle }}" uuid="{{ $uuid }}">
            @if(!$isEdit)
            <x-slot name="toolbar">
                <button type="button" class="btn btn-outline-info rounded" title="Cargar Persona" data-bs-toggle="modal"
                    data-bs-target="#searchPersonModal">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" height="24" width="24">
                        <path d="M11.250 17.250 A6.000 6.000 0 1 0 23.250 17.250 A6.000 6.000 0 1 0 11.250 17.250 Z"
                            fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                            stroke-width="1" />
                        <path d="M17.25 14.25L17.25 20.25" fill="none" stroke="currentColor" stroke-linecap="round"
                            stroke-linejoin="round" stroke-width="1" />
                        <path d="M14.25 17.25L20.25 17.25" fill="none" stroke="currentColor" stroke-linecap="round"
                            stroke-linejoin="round" stroke-width="1" />
                        <path d="M.75,17.25a6.753,6.753,0,0,1,9.4-6.208" fill="none" stroke="currentColor"
                            stroke-linecap="round" stroke-linejoin="round" stroke-width="1" />
                        <path d="M3.375 4.875 A4.125 4.125 0 1 0 11.625 4.875 A4.125 4.125 0 1 0 3.375 4.875 Z"
                            fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                            stroke-width="1" />
                    </svg>
                </button>
                <div wire:ignore.self class="modal fade" id="searchPersonModal" tabindex="-1"
                    aria-labelledby="searchPersonModalLabel" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <form>
                                <div class="modal-header">
                                    <h3 class="modal-title" id="searchPersonModalLabel">Cargar Persona</h3>
                                    <button
                                        x-on:hide-modal.window="document.getElementById('btn-close-modal-register').click();"
                                        id="btn-close-modal-register" type="button" class="btn-close"
                                        data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <div class="col">
                                        <!-- Card -->
                                        <div class="border-0 scroll-mt-3">
                                            <label class="form-label" for="">Buscar Persona</label>
                                            <input type="text" class="form-control"
                                                wire:model.live.debounce.150ms="personaSearch" list="personas">
                                            <datalist id="personas">
                                                @foreach ($personasResult as $persona)
                                                <option value="{{ $persona->nombres }}">{{ $persona->cedula }}
                                                </option>
                                                @endforeach
                                            </datalist>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer d-flex justify-content-end">
                                    <!-- Button -->
                                    <button type="button" wire:click="cargarPersona"
                                        class="btn btn-primary">Cargar</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </x-slot>
            @endif
        </x-persona.form>
    </div>

</div>

{{-- <script>
    const button =document.querySelector('#save_btn');
button.addEventListener('click', () => {


    setTimeout(() => {
        const url = `{{ route('clientes.index') }}`;
        window.location.href = url; // Replace with the desired URL
  }, 2000); // Delay in milliseconds (5000 = 5 seconds)
});


</script> --}}