<div>
    @section('title', $pageTitle)

    <div class="col">
        <form action="{{ route('cobranzas.store') }}" method="GET" class="row g-3" id="formCobranza">
            <!-- Card -->
            <div class="card border-0 scroll-mt-3" id="basicInformationSection">
                <div class="card-header">
                    <h2 class="h3 mb-0 text-center">{{ $pageTitle }}</h2>
                </div>

                <div class="card-body row mb-4">
                    {{-- Cliente --}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="cliente_id" class="col-form-label">Cliente</label>
                        </div>

                        <div>
                            <select class="form-select" name="cliente_id" id="cliente_id" required>
                                <option value="">Seleccione algun cliente </option>
                                @foreach ($clientes as $cliente)
                                <option value="{{ $cliente->id }}">
                                    @switch($TipoClientes::from($cliente->clientable_type))
                                    @case($TipoClientes::PERSONA)
                                    {{ $cliente->clientable->nombres }}
                                    @break

                                    @case($TipoClientes::EMPRESA)
                                    {{ $cliente->clientable->razon }}
                                    @break

                                    @default
                                    N/D
                                    @endswitch
                                </option>
                                @endforeach
                            </select>
                            <small class="text-danger">
                                @error('form.cliente_id')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>
                    {{-- Concepto --}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="concepto" class="col-form-label">Concepto</label>
                        </div>

                        <div>
                            <input class="form-control" id="concepto" name="concepto"
                                placeholder="Inserte concepto para cobro" required>
                            <small class="text-danger">
                                @error('form.concepto')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>
                    {{-- Monto --}}
                    <div class="col-sm-6 col-lg-4">
                        <div>
                            <label for="monto" class="col-form-label">Monto</label>
                        </div>

                        <div>
                            <input type="number" step="0.01" min="0" max="999999.99" class="form-control" id="monto" name="monto"
                                placeholder="Inserte monto para cobro" required>
                            <small class="text-danger">
                                @error('form.monto')
                                {{ $message }}
                                @enderror
                            </small>
                        </div>
                    </div>



                    {{-- Fin de formulario --}}
                    <div class="d-flex justify-content-end gap-2 mt-4">
                        <button type="submit" class="btn btn-primary">{{ __('Save') }}</button>
                    </div>
                </div>

            </div>

        </form>

    </div>

</div>