<div>
    @section('title', 'Historial de cobros realizados')


    <style>
        td {
            /* min-height: 60px;
            max-height: 70px; */
            /* max-width: 80px; */
            font-size: 14px;
        }

        .table * {
            border-bottom-width: 2px;
        }



        .table th,
        .table td {
            padding: 10px 15px 10px 5px;
        }

        .table thead th {
            padding: 0px 0px 10px 0px;
        }
    </style>
    <div class=" pt-2 d-flex flex-column">

        <header class="mb-4">
            <h1 class="text-center h1">Historial de cobros</h1>
        </header>




        {{-- Cobros pendientes personalizados --}}
        <div class="row mt-3">
            <div class="card shadow p-0">
                {{-- <div class="card shadow" style="height: 775px"> --}}

                    <div class="card-header pb-2">
                        <div class="row">
                            <p class="col">
                                Cobros de mensualidades pendientes
                            </p>

                            <div class="col  d-flex flex-column align-items-end">
                                <input class="form-control list-search mw-300px d-none  " wire:model.live="search"
                                    type="search" placeholder="Buscar">

                            </div>

                        </div>
                    </div>

                    <div class="card-body ">

                        <table class="table table-striped mt-40 datatable">
                            {{-- Cobros de mensaulidades de remotas --}}
                            <thead>
                                <tr>
                                    <th scope="col" class="text-center  ">#</th>
                                    <th scope="col" class="text-center  ">Cliente</th>
                                    <th scope="col" class="text-center  ">Remota</th>
                                    <th scope="col" class="text-center  ">Concepto</th>
                                    <th scope="col" class="text-center  ">Metodo de pago</th>
                                    <th scope="col" class="text-center  ">Monto</th>
                                    <th scope="col" class="text-center  ">Fecha</th>
                                    <th scope="col" class="text-center">Acción</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($cobros_historial as $cobro)
                                <tr>
                                    {{--= id --}}
                                    <td class="text-center">{{ $cobro->id }}</td>
                                    {{--= Nombre de cliente --}}
                                    <td scope="col" class="text-left ">
                                        {{($cobro->remota?->cliente->getClientName()??
                                        $cobro->cliente->getClientName()?? 'Error de
                                        cliente')}}
                                    </td>
                                    {{--= Nombre de equipo --}}
                                    <td scope="col" class="text-left ">
                                        {{ ($cobro->remota?->equipo ?? '')?? 'ERROR: Remota' }}
                                    </td>
                                    {{--= Concepto --}}
                                    <td scope="col" class="text-left ">
                                        {{ $cobro->concepto}}
                                    </td>
                                    {{--= Metodo de pago --}}
                                    <td scope="col" class="text-left ">
                                        {{ $cobro->payment_method?->getName() ?? 'N/R' }}
                                    </td>
                                    {{--= Monto --}}
                                    <td scope="col" class="text-left ">
                                        $@money($cobro->monto)
                                    </td>
                                    {{--= Fecha de cobro --}}
                                    <td scope="col" class="text-left">
                                        {{ $cobro->fecha_pago }}
                                    </td>
                                    {{--= acciones --}}
                                    <td scope="col" class="">
                                        <div class="text-center d-flex flex-row align-items-center justify-content-center gap-2">
                                            <!-- Botón ver recibo -->
                                            <a href="{{ route('recibos.ver', $cobro->id) }}" 
                                               target="_blank"
                                               class="btn btn-sm btn-info" 
                                               title="Ver recibo">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <!-- Botón descargar recibo -->
                                            <a href="{{ route('recibos.descargar', $cobro->id) }}" 
                                               class="btn btn-sm btn-success" 
                                               title="Descargar recibo">
                                                <i class="fas fa-download"></i>
                                            </a>
                                        </div>
                                    </td>


                                </tr>
                                @empty
                                <td colspan="8" class="text-center">No hay cobros por mensualidades proximos a 5
                                    dias a vencer</td>
                                @endforelse

                            </tbody>
                        </table>



                    </div>

                </div>

            </div>





        </div>

    </div>
</div>
