<div>
    @section('title', 'Cobros de mensualidades')


    <style>
        td {
            /* min-height: 60px;
            max-height: 70px; */
            /* max-width: 80px; */
            font-size: 14px;
        }

        .table * {
            border-bottom-width: 2px;
        }



        .table th,
        .table td {
            padding: 2px 5px 2px 5px;
        }

        .table thead th {
            padding: 0px 0px 10px 0px;
        }
    </style>
    <div class=" pt-2 d-flex flex-column">

        <header class="mb-4">
            <h1 class="text-center h1">{{ $title }} </h1>
        </header>



        {{-- Cobros pendientes personalizados --}}
        <div class="row mt-3">
            <div class="card shadow p-0">
                {{-- <div class="card shadow" style="height: 775px"> --}}

                <div class="card-header pb-2">
                    <div class="row">
                        <p class="col">
                            Cobros de mensualidades pendientes
                        </p>

                        <div class="col  d-flex flex-column align-items-end">
                            <input class="form-control list-search mw-300px d-none " wire:model.live="search"
                                type="search" placeholder="Buscar">

                        </div>

                    </div>
                </div>

                <div class="card-body ">

                    <table class="table datatable  mt-40">
                        {{-- Cobros de mensaulidades de remotas --}}
                        <thead>
                            <tr>
                                <th scope="col" class="text-center  ">#</th>
                                <th scope="col" class="text-center  ">Concepto</th>
                                <th scope="col" class="text-center  ">Remota</th>
                                <th scope="col" class="text-center  ">Cliente</th>
                                <th scope="col" class="text-center">Fecha de cobro</th>
                                <th scope="col" class="text-center">Fecha de proximo corte</th>
                                {{-- <th scope="col" class="text-center">Fecha de activacion cliente</th> --}}
                                <th scope="col" class="text-center">Plan</th>
                                <th scope="col" class="text-center">Monto</th>
                                <th scope="col" class="text-center">Acción</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($remotas_por_pagar as $remota)
                            {{-- @forelse ($remotas_por_pagar as $remota) --}}
                            <tr class="{{ $remota->remota->getColorPorVencimiento() }}">
                                {{--= id --}}
                                <td class="text-center">{{ $remota->cobro_id }}</td>
                                {{--= Concepto --}}
                                <td scope="col" class="text-left " style="width: 180px">
                                    {{ $remota->concepto."
                                        ". ucwords( $remota->mes_cobro_nombre) }}
                                </td>
                                {{--= Nombre de equipo --}}
                                <td scope="col" class="text-left " style="width: 200px">{{
                                        '('.$remota->remota->id.')'.$remota->remota->equipo
                                        }}</td>
                                {{--= Nombre de cliente --}}
                                <td scope="col" class="text-left " style="width: 100px">{{
                                        $remota->remota->cliente->getClientName()}}
                                </td>
                                {{--= Fecha de cobro --}}
                                <td scope="col" class="text-left   " style="width: 100px">{{
                                        $remota->cobro_fecha??'"DateError"' }}
                                    {{-- $remota->proxima_fecha_cobro??'"DateError"' }} --}}
                                    <br>
                                    {{
                                        "(".$remota->remota->getAtrasoPorVencimiento().": ".$remota->dias_diferencia
                                        .")"
                                        }}
                                </td>
                                {{--= Fecha de proximo cobro --}}
                                <td scope="col" class="text-left   " style="width: 100px">{{
                                        $remota->proxima_fecha_cobro??'"DateError2"' }}

                                </td>
                                {{--== Fecha de activacion --}}
                                {{-- <td scope="col" class="text-left ">{{
                                        $remota->remota->fecha_activacion }}
                                </td> --}}
                                {{--= Nombre del plan --}}
                                <td scope="col" class="text-left " style="width: 180px">{{
                                        $remota->remota->plan->nombre }}</td>
                                {{--= Cantidad pendiente --}}
                                <td scope="col" class="text-left " style="width: 100px">
                                    $@money($remota->cantidad_pendiente)
                                </td>
                                {{--= acciones --}}
                                <td scope="col" class="">
                                    <div class="text-center d-flex flex-row align-items-center ">

                                        @can('cobranzas.cobros_mensualidades.pagar')
                                        {{--=========== //////////////////////PAGAR/////////////////////// --}}
                                        {{-- boton de pagar --}}
                                        <button type="button"
                                            class="btn btn-xs btn-primary p-3 pt-1 pb-1 me-1 border border-dark"
                                            data-bs-toggle="modal" data-bs-target="#pagar_{{ $remota->remota->id }}"
                                            title="Pagar">

                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 580 530" {{--
                                                    fill="white" --}} class="nav-link-icon d-flex justify-items-center"
                                                height="18" width="18">>
                                                <!--!Font Awesome Free 6.5.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.-->
                                                <path
                                                    d="M112 112c0 35.3-28.7 64-64 64V336c35.3 0 64 28.7 64 64H464c0-35.3 28.7-64 64-64V176c-35.3 0-64-28.7-64-64H112zM0 128C0 92.7 28.7 64 64 64H512c35.3 0 64 28.7 64 64V384c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V128zM176 256a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zm80-48c0 8.8 7.2 16 16 16v64h-8c-8.8 0-16 7.2-16 16s7.2 16 16 16h24 24c8.8 0 16-7.2 16-16s-7.2-16-16-16h-8V208c0-8.8-7.2-16-16-16H272c-8.8 0-16 7.2-16 16z" />
                                            </svg>
                                        </button>
                                        @endcan
                                        
                                        {{-- Botón de Generar Factura --}}
                                        <a href="{{ route('cobros_mensualidades.factura', $remota->id) }}" 
                                            class="btn btn-xs btn-secondary p-3 pt-1 pb-1 me-1 text-white border border-dark"
                                            target="_blank"
                                            title="Generar Factura">
                                            <i class="fa-solid fa-file-invoice"></i>
                                        </a>

                                        @can('remotas_satelital.show_detail')
                                        <button type="button" class="btn btn-xs btn-info p-3 pt-1 pb-1 me-1" data-bs-toggle="modal"
                                            data-bs-target="#ver_remotas_{{  $remota->remota->uuid }}" title="Ver remotas">

                                            <i class="fa-regular fa-eye"></i>
                                        </button>
                                        @include('livewire.remota.includes.modales.show-detail', ['item' => $remota->remota])
                                        @endcan

                                        {{-- Botón morado de enviar mensaje (según licencia asociada) --}}
                                        @php $tieneLicencia = (bool)($remota->tiene_licencia_asociada ?? false); @endphp
                                        <button type="button"
                                            class="btn btn-xs p-3 pt-1 pb-1 me-1 text-white border border-dark"
                                            style="background-color:#6f42c1;"
                                            title="Enviar mensaje"
                                            @if($tieneLicencia)
                                                data-bs-toggle="modal" data-bs-target="#enviar_mensaje_{{ $remota->remota->id }}"
                                            @else
                                                disabled
                                            @endif
                                        >
                                            <i class="fa-regular fa-message"></i>
                                        </button>

                                        {{-- Modal: Enviar mensaje --}}
                                        @if($tieneLicencia)
                                        <div class="modal fade" id="enviar_mensaje_{{ $remota->remota->id }}" tabindex="-1"
                                            aria-labelledby="enviar_mensaje_label_{{ $remota->remota->id }}" aria-hidden="true">
                                            <div class="modal-dialog modal-lg modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="enviar_mensaje_label_{{ $remota->remota->id }}">Enviar mensaje</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                <div class="mb-3">
                                                                    <label for="tipo_mensaje_{{ $remota->remota->id }}" class="form-label">Tipo de mensaje</label>
                                                                    <select class="form-select" id="tipo_mensaje_{{ $remota->remota->id }}"
                                                                        onchange="actualizarPreviewMensaje({{ $remota->remota->id }})">
                                                                        <option value="">Seleccione una opción</option>
                                                                        <option value="proximo">Próximo a vencer</option>
                                                                        <option value="vencido">Vencido</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <label class="form-label">Previsualización</label>
                                                                <div id="preview_mensaje_{{ $remota->remota->id }}" class="form-control" style="min-height: 120px"></div>
                                                            </div>
                                                        </div>

                                                        {{-- Mensajes predefinidos ocultos para uso del preview --}}
                                                        <div id="mensaje_proximo_{{ $remota->remota->id }}" class="d-none">
                                                            Estimado(a) {{ $remota->remota->cliente->getClientName() }}, su servicio asociado al equipo "{{ $remota->remota->equipo }}" está próximo a vencer.
                                                        </div>
                                                        <div id="mensaje_vencido_{{ $remota->remota->id }}" class="d-none">
                                                            Estimado(a) {{ $remota->remota->cliente->getClientName() }}, su servicio asociado al equipo "{{ $remota->remota->equipo }}" se encuentra vencido.
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                                                        <button type="button" class="btn btn-primary"
                                                            onclick="emitirEnviarMensaje(event, {{ $remota->remota->id }})">Aceptar</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        @endif

                                        @can('cobranzas.cobros_mensualidades.pagar')
                                        <!-- Modal pagar  -->
                                        <div class="modal modal-xl fade" id="pagar_{{ $remota->remota->id }}"
                                            tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header bg-info">

                                                        <h1 class="modal-title fs-5" id="exampleModalLabel">
                                                            PAGAR
                                                            &nbsp
                                                            - &nbsp
                                                        </h1>

                                                        <span>

                                                            {{
                                                                $remota->remota->equipo
                                                                }}
                                                        </span>
                                                        <button type="button" class="btn-close"
                                                            data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <form wire:submit.prevent="pagar({{ $remota->remota->id }})">

                                                        <div class="modal-body">
                                                            {{-- informacion original del plan --}}
                                                            <p class="text-muted">Informacion del plan </p>
                                                            <div class="row">
                                                                <div class="col col-md-4">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Nombre del PLAN
                                                                        </label>
                                                                        <input type="email" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            placeholder=""
                                                                            value="{{ $remota->remota->plan->nombre }}"
                                                                            disabled>
                                                                    </div>
                                                                </div>
                                                                {{-- Costo de plan --}}
                                                                <div class="col col-md-4">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Costo
                                                                        </label>
                                                                        <input type="number" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            placeholder=""
                                                                            value="{{ $remota->remota->plan->costo }}"
                                                                            disabled>
                                                                    </div>
                                                                </div>
                                                                {{-- precio original de plan --}}
                                                                <div class="col col-md-4">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Precio original
                                                                        </label>
                                                                        <input type="number" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            placeholder=""
                                                                            value="{{ $remota->remota->plan->precio }}"
                                                                            disabled>
                                                                    </div>
                                                                </div>

                                                            </div>
                                                            <hr>

                                                            {{-- informacion asociada a la remota --}}
                                                            <div class="row">
                                                                {{-- Precio de remota --}}
                                                                <div class="col col-md-2">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Precio de remota
                                                                        </label>
                                                                        <input type="number" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            value="{{ $remota->remota->costo }}"
                                                                            min="0" step="0.01" disabled>
                                                                    </div>
                                                                </div>
                                                                {{-- Comision de vendedor--}}
                                                                <div class="col col-md-2">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Comision
                                                                        </label>
                                                                        <input type="number" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            value="{{ $remota->remota->comision }}"
                                                                            min="0" step="0.01" disabled>
                                                                    </div>
                                                                </div>
                                                                {{-- Costo de remota --}}
                                                                <div class="col col-md-4">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Costo (Comision +
                                                                            Costo de plan)
                                                                        </label>
                                                                        <input type="number" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            value="{{ $remota->remota->getCostoDeVenta() }}"
                                                                            min="0" step="0.01" disabled>
                                                                    </div>
                                                                </div>
                                                                {{-- Utilidad estimada--}}
                                                                <div class="col col-md-4">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Utilidad estimada
                                                                            (Pago completo)
                                                                        </label>
                                                                        <input type="number" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            value="{{ $remota->remota->getUtilidadEstimada()  }}"
                                                                            min="0" step="0.01" disabled required>
                                                                    </div>
                                                                </div>

                                                            </div>

                                                            {{-- Informacion de pagos realizados --}}
                                                            <div class="row">
                                                                {{-- Cantidad pagada --}}
                                                                <div class="col col-md-4">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Cantidad pagada
                                                                        </label>
                                                                        <input type="number" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            value="{{ $remota->cantidad_pagada }}"
                                                                            min="0" step="0.01" disabled>
                                                                    </div>
                                                                </div>
                                                                {{-- Cantidad pendiente --}}
                                                                <div class="col col-md-4">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Cantidad
                                                                            pendiente
                                                                        </label>
                                                                        <input type="number" class="form-control"
                                                                            id="exampleFormControlInput1" {{--
                                                                                wire:model="monto_cobro" --}}
                                                                            placeholder="{{ $remota->cantidad_pendiente }}"
                                                                            value="{{$remota->cantidad_pendiente }}"
                                                                            min="0" step="0.01"
                                                                            max="{{ $remota->cantidad_pendiente }}"
                                                                            disabled>
                                                                    </div>
                                                                </div>
                                                                {{-- Utilidad actual --}}
                                                                @php
                                                                $costo_de_venta = $remota->remota->plan->costo+
                                                                $remota->remota->comision;
                                                                $utilidad_actual = $remota->cantidad_pagada -
                                                                $costo_de_venta;
                                                                @endphp
                                                                <div class="col col-md-4">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Utilidad Actual
                                                                        </label>
                                                                        <input type="number" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            value="{{ $utilidad_actual }}" min="0"
                                                                            step="0.01" disabled>
                                                                    </div>
                                                                </div>
                                                                {{-- Nombre del vendedor --}}
                                                                <div class="col col-md-4">
                                                                    <div class="mb-3">
                                                                        <label for="vendedor_name"
                                                                            class="form-label">Vendedor
                                                                        </label>
                                                                        <input type="text" class="form-control"
                                                                            id="vendedor_name"
                                                                            value="{{ $remota->remota->vendedor->persona->nombres }}"
                                                                            disabled>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <hr>
                                                            {{-- Pago actual a realizar --}}
                                                            <div class="row">

                                                                {{-- Fecha de proximo cobro --}}
                                                                <div class="col col-md-3">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Fecha
                                                                            de proximo
                                                                            cobro
                                                                        </label>
                                                                        <input type="date" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            placeholder="" disabled
                                                                            value="{{ $remota->proxima_fecha_cobro_date }}">
                                                                    </div>
                                                                </div>
                                                                {{-- Payment_method / metodo de pago --}}
                                                                <div class="col col-md-5">
                                                                    <div class="mb-3">
                                                                        <label
                                                                            for="payment_method_id_{{ $remota->remota->id }}"
                                                                            class="form-label">Metodo de pago
                                                                        </label>

                                                                        <select class="form-select"
                                                                            name="payment_method_id_{{ $remota->remota->id }}"
                                                                            wire:model="payment_method_id"
                                                                            id="payment_method_id_{{ $remota->remota->id }}"
                                                                            required>

                                                                            <option value="">Seleccione una
                                                                                opcion
                                                                            </option>
                                                                            @forelse ($payment_methods as $pm)
                                                                            <option value="{{ $pm->id }}">
                                                                                {{ $pm->name }}
                                                                            </option>

                                                                            @empty
                                                                            <option value="">No hay metodos de
                                                                                pago
                                                                                registrados</option>
                                                                            @endforelse


                                                                        </select>
                                                                        <small class="text-danger">
                                                                            @error('payment_method')
                                                                            {{ $message }}
                                                                            @enderror
                                                                        </small>
                                                                    </div>
                                                                </div>
                                                                {{-- Monto a pagar --}}
                                                                <div class="col col-md-3">
                                                                    <div class="mb-3">
                                                                        <label for="monto_cobro"
                                                                            class="form-label">Monto a pagar
                                                                        </label>
                                                                        <input required type="number" class="form-control"
                                                                            id="monto_cobro_{{ $remota->remota->id }}"
                                                                            wire:model="monto_cobro"
                                                                            placeholder="{{ $remota->cantidad_pendiente }}"
                                                                            value="{{ $remota->cantidad_pendiente}}"
                                                                            min="0.01" step="0.01"
                                                                            max="{{ $remota->cantidad_pendiente}}">
                                                                    </div>
                                                                </div>
                                                            </div>


                                                            {{-- Cantidad en GB consumidos --}}
                                                            {{-- <div class="row">
                                                                    <div class="col col-md-3 ">
                                                                        <div class="mb-3">
                                                                            <label for="exampleFormControlInput1"
                                                                                class="form-label">Cantidad de
                                                                                GB
                                                                            </label>
                                                                            <input type="number" class="form-control"
                                                                                id="exampleFormControlInput1"
                                                                                placeholder="" value="20GB">
                                                                        </div>
                                                                    </div>
                                                                </div> --}}
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary"
                                                                data-bs-dismiss="modal">Cerrar</button>
                                                            <button type="button" onclick="
                                                                    emitirPagar(event,{{ $remota->remota->id }})"
                                                                class="btn btn-primary">Pagar</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        @endcan


                                        {{--========== //////////////////////EXONERAR/////////////////////// --}}

                                        @can('cobranzas.cobros_mensualidades.exonerar')
                                        <button type="button"
                                            class="btn btn-sm btn-warning p-3 pt-1 pb-1 me-1 border border-dark"
                                            data-bs-toggle="modal"
                                            data-bs-target="#exonerar_mensualidad_{{ $remota->remota->id }}"
                                            title="Exonerar pago">

                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                                                class="nav-link-icon d-flex justify-items-center" height="18"
                                                width="18">
                                                <!--!Font Awesome Free 6.6.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.-->
                                                <path
                                                    d="M128 0c13.3 0 24 10.7 24 24l0 40 144 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 40 0c35.3 0 64 28.7 64 64l0 16 0 48 0 256c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 192l0-48 0-16C0 92.7 28.7 64 64 64l40 0 0-40c0-13.3 10.7-24 24-24zM400 192L48 192l0 256c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-256zm-95 89l-47 47 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z" />
                                            </svg>

                                        </button>
                                        <!-- Modal exonerar pago  -->
                                        <div class="modal modal-xl fade"
                                            id="exonerar_mensualidad_{{ $remota->remota->id }}" tabindex="-1"
                                            aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog ">
                                                <div class="modal-content">
                                                    <div class="modal-header bg-warning">

                                                        <h1 class="modal-title fs-5" id="exampleModalLabel">
                                                            EXONERAR
                                                            &nbsp - &nbsp
                                                        </h1>

                                                        <span>

                                                            {{
                                                                $remota->remota->equipo
                                                                }}
                                                        </span>
                                                        <button type="button" class="btn-close"
                                                            data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <form
                                                        wire:submit.prevent="exonerarPagoCobroRemota({{ $remota->remota->id }})">
                                                        <p class="form-text ms-5 me-5">Esta accion Cancela/Omite
                                                            el
                                                            pago
                                                            correspondiente, asumiento su utilidad negativa</p>

                                                        <div class="modal-body">
                                                            {{-- informacion original del plan --}}
                                                            <div class="row">
                                                                <div class="col col-md-4">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Nombre del PLAN
                                                                        </label>
                                                                        <input type="email" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            placeholder=""
                                                                            value="{{ $remota->remota->plan->nombre }}"
                                                                            disabled>
                                                                    </div>
                                                                </div>
                                                                {{-- Costo de plan --}}
                                                                <div class="col col-md-4">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Costo
                                                                        </label>
                                                                        <input type="number" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            placeholder=""
                                                                            value="{{ $remota->remota->plan->costo }}"
                                                                            disabled>
                                                                    </div>
                                                                </div>
                                                                {{-- precio original de plan --}}
                                                                <div class="col col-md-4">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Precio original
                                                                        </label>
                                                                        <input type="number" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            placeholder=""
                                                                            value="{{ $remota->remota->plan->precio }}"
                                                                            disabled>
                                                                    </div>
                                                                </div>

                                                            </div>

                                                            {{-- informacion asociada a la remota --}}
                                                            <div class="row">
                                                                {{-- Precio de remota --}}
                                                                <div class="col col-md-2">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Precio de remota
                                                                        </label>
                                                                        <input type="number" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            value="{{ $remota->remota->costo }}"
                                                                            min="0" step="0.01" disabled>
                                                                    </div>
                                                                </div>
                                                                {{-- Comision de vendedor--}}
                                                                <div class="col col-md-2">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Comision
                                                                        </label>
                                                                        <input type="number" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            value="{{ $remota->remota->comision }}"
                                                                            min="0" step="0.01" disabled>
                                                                    </div>
                                                                </div>
                                                                {{-- Costo de remota --}}
                                                                <div class="col col-md-4">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Costo (Comision +
                                                                            Costo de plan)
                                                                        </label>
                                                                        <input type="number" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            value="{{ $remota->remota->getCostoDeVenta() }}"
                                                                            min="0" step="0.01" disabled>
                                                                    </div>
                                                                </div>
                                                                {{-- Utilidad estimada--}}
                                                                <div class="col col-md-4">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Utilidad estimada
                                                                            (Pago completo)
                                                                        </label>
                                                                        <input type="number" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            value="{{ $remota->remota->getUtilidadEstimada()  }}"
                                                                            min="0" step="0.01" disabled required>
                                                                    </div>
                                                                </div>

                                                            </div>

                                                            {{-- Informacion de pagos realizados --}}
                                                            <div class="row">
                                                                {{-- Cantidad pagada --}}
                                                                <div class="col col-md-4">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Cantidad pagada
                                                                        </label>
                                                                        <input type="number" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            value="{{$remota->cantidad_pagada }}"
                                                                            min="0" step="0.01" disabled>
                                                                    </div>
                                                                </div>
                                                                {{-- Cantidad pendiente --}}
                                                                <div class="col col-md-4">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Cantidad
                                                                            pendiente
                                                                        </label>
                                                                        <input type="number" class="form-control"
                                                                            id="exampleFormControlInput1" {{--
                                                                                wire:model="monto_cobro" --}}
                                                                            placeholder="{{ $remota->cantidad_pendiente  }}"
                                                                            value="{{ $remota->cantidad_pendiente }}"
                                                                            min="0" step="0.01"
                                                                            max="{{ $remota->cantidad_pendiente }}"
                                                                            disabled>
                                                                    </div>
                                                                </div>
                                                                @php
                                                                // $costo_de_venta = $remota->remota->plan->costo+
                                                                // $remota->remota->comision;
                                                                $utilidad_actual = $remota->cantidad_pagada -
                                                                $remota->remota->getCostoDeVenta();
                                                                @endphp
                                                                {{-- Utilidad actual --}}
                                                                <div class="col col-md-4">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Utilidad Actual
                                                                        </label>
                                                                        <input type="number" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            value="{{ $utilidad_actual }}" min="0"
                                                                            step="0.01" disabled>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <hr>
                                                            {{-- Pago actual a realizar --}}
                                                            <div class="row">

                                                                {{-- Fecha de proximo cobro --}}
                                                                <div class="col col-md-3">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Fecha
                                                                            de proximo
                                                                            cobro
                                                                        </label>
                                                                        <input type="date" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            placeholder="" disabled
                                                                            value="{{ $remota->proxima_fecha_cobro_date }}">
                                                                    </div>
                                                                </div>
                                                                {{-- Monto a exonerar --}}
                                                                <div class="col col-md-3">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Monto a exonerar
                                                                        </label>
                                                                        <input type="number" class="form-control"
                                                                            id="exampleFormControlInput1" {{--
                                                                                wire:model="monto_cobro" --}}
                                                                            placeholder="{{ $remota->cantidad_pendiente  }}"
                                                                            value="{{ $remota->cantidad_pendiente }}"
                                                                            min="0" step="0.01" disabled
                                                                            max="{{ $remota->cantidad_pendiente }}">
                                                                    </div>
                                                                </div>
                                                                <div class="col col-md-8">
                                                                    <div class="mb-3">
                                                                        <label for="exampleFormControlInput1"
                                                                            class="form-label">Observaciones
                                                                        </label>
                                                                        <input type="text" class="form-control"
                                                                            id="exampleFormControlInput1"
                                                                            wire:model="observaciones"
                                                                            placeholder="Detalle porque se elimino"
                                                                            value="">
                                                                    </div>
                                                                </div>
                                                            </div>


                                                            {{-- Cantidad en GB consumidos --}}
                                                            {{-- <div class="row">
                                                                    <div class="col col-md-3 ">
                                                                        <div class="mb-3">
                                                                            <label for="exampleFormControlInput1"
                                                                                class="form-label">Cantidad de
                                                                                GB
                                                                            </label>
                                                                            <input type="number" class="form-control"
                                                                                id="exampleFormControlInput1"
                                                                                placeholder="" value="20GB">
                                                                        </div>
                                                                    </div>
                                                                </div> --}}

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary"
                                                                data-bs-dismiss="modal">Cerrar</button>
                                                            <button type="button" onclick="
                                                                    emitirExonerar(event,{{ $remota->remota->id }})"
                                                                class="btn btn-warning">Exonerar</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        @endcan
                                        @can('cobranzas.cobros_mensualidades.enviar_ws')
                                        {{--========= //////////////////////WHATSAPP/////////////////////// --}}

                                        {{-- Boton de whatsapp --}}
                                        <a href="https://wa.me/{{ $remota->remota->cliente->getWhatsapp() }}?text=Hola,%20Tienes%20un%20pago%20pendiente%20de%20{{ $remota->remota->costo }}$,%20por%20favor%20recuerda%20enviar%20tu%20forma%20de%20pago%20a%20tiempo."
                                            class="btn btn-xs btn-success p-3 pt-1 pb-1 me-1 border border-dark"
                                            target="_blank" title="Mandar mensaje a whatsapp">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" {{--
                                                    fill="white" --}} class="nav-link-icon d-flex justify-items-center"
                                                height="18" width="18">
                                                <!--!Font Awesome Free 6.5.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.-->
                                                <path
                                                    d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-118-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7 .9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z" />
                                            </svg>


                                        </a>

                                        @endcan

                                    </div>
                                </td>


                            </tr>
                            @empty
                            <td colspan="8" class="text-center">No hay cobros por mensualidades proximos a 5
                                dias a vencer</td>
                            @endforelse

                        </tbody>
                    </table>


                </div>
                {{-- <div class="card-footer">
                        <div class="d-flex justify-content-center">
                            {{ $remotas_por_pagar->links() }}
            </div>
        </div> --}}
    </div>

</div>




</div>

</div>
</div>
<script>
    function emitirPagar(e, id) {
        e.preventDefault();
        let payment_mehtod = document.getElementById('payment_method_id_' + id)
        let monto_cobro = document.getElementById('monto_cobro_' + id)
        Livewire.dispatch('listenersPagar', {
            remota: id,
            payment_method_id: Number(payment_mehtod.value),
            monto_cobro: Number(monto_cobro.value)
        })
    }

    function emitirExonerar(e, id) {
        e.preventDefault();
        // let payment_mehtod = document.getElementById('payment_method_id')
        // let monto_cobro = document.getElementById('monto_cobro')
        Livewire.dispatch('listenersExonerar', {
            remota: id,
            //  payment_method_id:Number(payment_mehtod.value),
            //  monto_cobro:Number(monto_cobro.value)
        })
    }
</script>
<script>
    // Actualiza la previsualización del mensaje según tipo seleccionado
    function actualizarPreviewMensaje(id) {
        const tipo = document.getElementById('tipo_mensaje_' + id).value;
        const preview = document.getElementById('preview_mensaje_' + id);
        const proximo = document.getElementById('mensaje_proximo_' + id)?.innerText?.trim() || '';
        const vencido = document.getElementById('mensaje_vencido_' + id)?.innerText?.trim() || '';
        if (tipo === 'proximo') {
            preview.textContent = proximo;
        } else if (tipo === 'vencido') {
            preview.textContent = vencido;
        } else {
            preview.textContent = '';
        }
    }

    // Emite el evento de enviar mensaje (por ahora solo muestra realizado)
    function emitirEnviarMensaje(e, id) {
        e.preventDefault();
        const tipo = document.getElementById('tipo_mensaje_' + id).value;
        if (!tipo) {
            alert('Seleccione un tipo de mensaje');
            return;
        }
        // Enviar payload como objeto, consistente con otros listeners
        Livewire.dispatch('listenersEnviarMensaje', { remota: id, tipo: tipo });

        // Cerrar el modal y limpiar el backdrop para evitar efecto de pantalla congelada
        const modalEl = document.getElementById('enviar_mensaje_' + id);
        if (modalEl) {
            const modalInstance = bootstrap.Modal.getInstance(modalEl) || new bootstrap.Modal(modalEl);
            modalInstance.hide();
        }
        // Remover backdrop manualmente en caso de quedar persistente
        document.querySelectorAll('.modal-backdrop').forEach((bd) => bd.remove());
        document.body.classList.remove('modal-open');
        document.body.style.paddingRight = '';
    }
</script>
