<div>
    @section('title', 'Cobros')


    <style>
        td {
            /* min-height: 60px;
            max-height: 70px; */
            /* max-width: 80px; */
            font-size: 14px;
        }

        .table * {
            border-bottom-width: 2px;
        }



        .table th,
        .table td {
            padding: 2px 5px 2px 5px;
        }

        .table thead th {
            padding: 0px 0px 10px 0px;
        }
    </style>
    <div class=" pt-2 d-flex flex-column">

        <header class="mb-4">
            <h1 class="text-center h1">Cobros pendientes</h1>
        </header>




        {{-- Cobros pendientes personalizados --}}
        <div class="row mt-3">
            <div class="card shadow p-0">
                {{-- <div class="card shadow" style="height: 775px"> --}}

                    <div class="card-header pb-2">
                        <div class="row">
                            <p class="col">
                                Cobros pendientes
                            </p>
                            @can('cobranzas.cobros_particulares.agregar')
                            <div class="col  d-flex flex-column align-items-center">
                                <a class="btn btn-primary  " href="{{ route('cobranzas.create') }}">Agregar</a>
                            </div>
                            @endcan
                            <div class="col  d-flex flex-column align-items-end">
                                <input class="form-control list-search mw-300px d-none  "
                                    wire:model.live="search_cobros" type="search_cobros" placeholder="Buscar">

                            </div>

                        </div>
                    </div>

                    <div class="card-body ">
                        <div class="table-responsive mt-40">

                            <table class="table datatable">
                                {{-- Cobros --}}
                                <thead>
                                    <tr>
                                        <th scope="col" class="text-left ">Concepto</th>
                                        <th scope="col" class="text-left ">Cliente</th>
                                        <th scope="col" class="text-left ">Fecha</th>
                                        {{-- <th scope="col" class="text-left "></th> --}}
                                        <th scope="col" class="text-left ">Monto</th>
                                        <th scope="col" class="text-center">Acción</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($cobros as $cobro)
                                    <tr>
                                        {{-- == Concepto --}}
                                        <td class="text-left  p-3">{{ $cobro->concepto }}</td>
                                        {{-- == Nombre cliente --}}
                                        <td class="text-left  p-3">{{ $cobro->cliente->getClientName() }}</td>
                                        {{-- == Fecha de cobro --}}
                                        <td class="text-left  p-3">{{ $cobro->fecha_de_cobro }}</td>
                                        {{-- == Monto --}}
                                        <td class="text-left  p-3">$
                                            @money($cobro->cantidadPendienteDelUltimoCobroPendiente())</td>
                                        {{-- == Acciones --}}
                                        <td class="text-center  p-3">
                                            <div
                                                class="text-center d-flex flex-row align-items-center  justify-content-center">

                                                {{-- ==//////////////////////PAGAR/////////////////////// --}}
                                                @can('cobranzas.cobros_particulares.pagar')
                                                {{-- Pagar cobro --}}
                                                <button type="button"
                                                    class="btn btn-sm btn-primary p-3 pt-1 pb-1 border border-dark"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#pagar_cobro_{{ $cobro->id }}">
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 580 530" {{--
                                                        fill="white" --}}
                                                        class="nav-link-icon d-flex justify-items-center" height="18"
                                                        width="18">>
                                                        <!--!Font Awesome Free 6.5.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.-->
                                                        <path
                                                            d="M112 112c0 35.3-28.7 64-64 64V336c35.3 0 64 28.7 64 64H464c0-35.3 28.7-64 64-64V176c-35.3 0-64-28.7-64-64H112zM0 128C0 92.7 28.7 64 64 64H512c35.3 0 64 28.7 64 64V384c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V128zM176 256a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zm80-48c0 8.8 7.2 16 16 16v64h-8c-8.8 0-16 7.2-16 16s7.2 16 16 16h24 24c8.8 0 16-7.2 16-16s-7.2-16-16-16h-8V208c0-8.8-7.2-16-16-16H272c-8.8 0-16 7.2-16 16z" />
                                                    </svg>
                                                </button>
                                                <!-- Modal pagar  -->
                                                <div class="modal modal-lg fade" id="pagar_cobro_{{ $cobro->id }}"
                                                    tabindex="-1" aria-labelledby="modal_cobro" aria-hidden="true">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header bg-info">

                                                                <h1 class="modal-title fs-5" id="exampleModalLabel">
                                                                    PAGAR
                                                                    &nbsp
                                                                    -
                                                                    &nbsp
                                                                </h1>

                                                                <span>

                                                                    {{
                                                                    $cobro->concepto
                                                                    }}
                                                                </span>
                                                                <button type="button" class="btn-close"
                                                                    data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <form wire:submit.prevent="pagar_cobro({{ $cobro->id }})">
                                                                <div class=" modal-body">
                                                                    <div class="row">
                                                                        {{-- Cliente --}}
                                                                        <div class="col col-md-6">
                                                                            <div class="mb-3">
                                                                                <label for="Cliente"
                                                                                    class="form-label">Cliente</label>
                                                                                <input type="text" class="form-control"
                                                                                    id="Cliente" placeholder=""
                                                                                    value="{{$cobro->cliente->getClientName() }}"
                                                                                    disabled>
                                                                            </div>
                                                                        </div>
                                                                        {{-- Concepto --}}
                                                                        <div class="col col-md-8">
                                                                            <div class="mb-3">
                                                                                <label for="Concepto"
                                                                                    class="form-label">Concepto a
                                                                                    pagar</label>
                                                                                <input type="text" class="form-control"
                                                                                    id="Concepto" placeholder=""
                                                                                    value="{{$cobro->concepto }}"
                                                                                    disabled>
                                                                            </div>
                                                                        </div>

                                                                        {{-- Monto --}}
                                                                        <div class="col col-md-4">
                                                                            <div class="mb-3">
                                                                                <label
                                                                                    for="monto_cobro_{{ $cobro->id }}"
                                                                                    class="form-label">Monto
                                                                                    a
                                                                                    pagar
                                                                                </label>
                                                                                <input type="number"
                                                                                    class="form-control"
                                                                                    id="monto_cobro_{{ $cobro->id }}"
                                                                                    wire:model="monto_cobro"
                                                                                    placeholder="{{ $cobro->cantidadPendienteDelUltimoCobroPendiente() }}"
                                                                                    value="{{ $cobro->monto }}" min="0"
                                                                                    step="0.01" required>
                                                                            </div>
                                                                        </div>

                                                                        {{-- Fecha de pago --}}
                                                                        <div class="col col-md-4">
                                                                            <div class="mb-3">
                                                                                <label for="fecha_{{ $cobro->id }}"
                                                                                    class="form-label">Fecha
                                                                                    de
                                                                                    pago
                                                                                </label>
                                                                                <input type="date" class="form-control"
                                                                                    id="fecha_{{ $cobro->id }}"
                                                                                    wire:model="fecha_cobro"
                                                                                    placeholder="" value="" required>
                                                                            </div>
                                                                        </div>

                                                                    </div>

                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-secondary"
                                                                        data-bs-dismiss="modal">Cerrar</button>
                                                                    <button type="submit" onclick="
                                                                    emitirPagar(event,{{ $cobro->id }})"
                                                                        class="btn btn-primary">Pagar</button>

                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endcan


                                                {{--== //////////////////////EXONERAR/////////////////////// --}}
                                                @can('cobranzas.cobros_particulares.exonerar')
                                                {{-- Boton de exonerar --}}
                                                <button type="button"
                                                    class="btn btn-sm btn-warning p-3 pt-1 pb-1  border border-dark"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#exonerar_cobro_{{ $cobro->id }}"
                                                    title="Exonerar pago">

                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"
                                                        class="nav-link-icon d-flex justify-items-center" height="18"
                                                        width="18">
                                                        <!--!Font Awesome Free 6.6.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.-->
                                                        <path
                                                            d="M128 0c13.3 0 24 10.7 24 24l0 40 144 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 40 0c35.3 0 64 28.7 64 64l0 16 0 48 0 256c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 192l0-48 0-16C0 92.7 28.7 64 64 64l40 0 0-40c0-13.3 10.7-24 24-24zM400 192L48 192l0 256c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-256zm-95 89l-47 47 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z" />
                                                    </svg>

                                                </button>
                                                <!-- Modal exonerar pago  -->
                                                <div class="modal modal-lg fade" id="exonerar_cobro_{{ $cobro->id }}"
                                                    tabindex="-1" aria-labelledby="exampleModalLabel"
                                                    aria-hidden="true">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header bg-warning">
                                                                <h1 class="modal-title fs-5" id="exampleModalLabel">
                                                                    EXONERAR
                                                                    &nbsp -
                                                                    &nbsp
                                                                </h1>

                                                                <span>

                                                                    {{
                                                                    $cobro->concepto
                                                                    }}
                                                                </span>
                                                                <button type="button" class="btn-close"
                                                                    data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <form wire:submit="exonerar_cobro({{ $cobro->id }})">
                                                                <p class="form-text ms-5 me-5">Esta accion Cancela/Omite
                                                                    el
                                                                    pago
                                                                    correspondiente, asumiento su utilidad negativa</p>
                                                                <div class="modal-body">

                                                                    <div class="row">
                                                                        {{-- Concepto --}}
                                                                        <div class="col col-md-8">
                                                                            <div class="mb-3">
                                                                                <label for="Concepto"
                                                                                    class="form-label">Concepto a
                                                                                    pagar</label>
                                                                                <input type="text" class="form-control"
                                                                                    id="Concepto" placeholder=""
                                                                                    value="{{$cobro->concepto }}"
                                                                                    disabled>
                                                                            </div>
                                                                        </div>
                                                                        {{-- Monto --}}
                                                                        <div class="col col-md-4">
                                                                            <div class="mb-3">
                                                                                <label for="monto"
                                                                                    class="form-label">Monto
                                                                                </label>
                                                                                <input type="number"
                                                                                    class="form-control" id="monto" {{--
                                                                                    wire:model="monto_cobro" --}}
                                                                                    placeholder="{{ $cobro->cantidadPendienteDelUltimoCobroPendiente() }}"
                                                                                    value="{{ $cobro->cantidadPendienteDelUltimoCobroPendiente() }}"
                                                                                    min="0" step="0.01" disabled>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col col-md-8">
                                                                            <div class="mb-3">
                                                                                <label
                                                                                    for="observaciones_{{ $cobro->id }}"
                                                                                    class="form-label">Observaciones
                                                                                </label>
                                                                                <input type="text" class="form-control"
                                                                                    id="observaciones_{{ $cobro->id }}"
                                                                                    wire:model="observaciones"
                                                                                    placeholder="Detalle porque se elimino"
                                                                                    value="">
                                                                            </div>
                                                                        </div>

                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-secondary"
                                                                        data-bs-dismiss="modal">Cerrar</button>
                                                                    <button type="submit" onclick="
                                                                    emitirExonerar(event,{{ $cobro->id  }})"
                                                                        class="btn btn-warning">Exonerar</button>

                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endcan

                                                {{--== //////////////////////ELIMINAR/////////////////////// --}}
                                                @can('cobranzas.cobros_particulares.eliminar_cobro')
                                                {{-- Boton de eliminar --}}
                                                <button type="button"
                                                    class="btn btn-sm btn-danger p-3 pt-1 pb-1  border border-dark"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#eliminar_cobro_{{ $cobro->id }}"
                                                    title="Eliminar pago">
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 550 500" {{--
                                                        fill="white" --}}
                                                        class="nav-link-icon d-flex justify-items-center" height="18"
                                                        width="18">
                                                        <!--!Font Awesome Free 6.5.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.-->
                                                        <path
                                                            d="M135.2 17.7C140.6 6.8 151.7 0 163.8 0H284.2c12.1 0 23.2 6.8 28.6 17.7L320 32h96c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 96 0 81.7 0 64S14.3 32 32 32h96l7.2-14.3zM32 128H416V448c0 35.3-28.7 64-64 64H96c-35.3 0-64-28.7-64-64V128zm96 64c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16zm96 0c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16zm96 0c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16z" />
                                                    </svg>
                                                </button>
                                                <!-- Modal eliminar cobro  -->
                                                <div class="modal modal-md fade" id="eliminar_cobro_{{ $cobro->id }}"
                                                    tabindex="-1" aria-labelledby="exampleModalLabel"
                                                    aria-hidden="true">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header bg-danger">
                                                                <h1 class="modal-title fs-5" id="exampleModalLabel">
                                                                    ELIMINAR
                                                                    &nbsp -
                                                                    &nbsp
                                                                </h1>

                                                                <span>

                                                                    {{
                                                                    $cobro->concepto
                                                                    }}
                                                                </span>
                                                                <button type="button" class="btn-close"
                                                                    data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <form wire:submit="eliminar_cobro({{ $cobro->id }})">
                                                                <p class="form-text ms-5 me-5">Esta accion Elimina
                                                                    totalmente el
                                                                    cobro</p>
                                                                <div class="modal-body ">

                                                                    <div class="row d-flex justify-content-center">
                                                                        {{-- Concepto --}}
                                                                        <div class="col col-md-10">
                                                                            <div class="mb-3">
                                                                                <label for="Concepto"
                                                                                    class="form-label">Concepto a
                                                                                    pagar</label>
                                                                                <input type="text" class="form-control"
                                                                                    id="Concepto" placeholder=""
                                                                                    value="{{$cobro->concepto }}"
                                                                                    disabled>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row  justify-content-center">

                                                                        {{-- Monto --}}
                                                                        <div class="col col-md-10 ">
                                                                            <div class="mb-3">
                                                                                <label for="monto"
                                                                                    class="form-label">Monto
                                                                                </label>
                                                                                <input type="number"
                                                                                    class="form-control" id="monto" {{--
                                                                                    wire:model="monto_cobro" --}}
                                                                                    placeholder="{{ $cobro->cantidadPendienteDelUltimoCobroPendiente() }}"
                                                                                    value="{{ $cobro->cantidadPendienteDelUltimoCobroPendiente() }}"
                                                                                    min="0" step="0.01" disabled>
                                                                            </div>
                                                                        </div>
                                                                    </div>


                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-secondary"
                                                                        data-bs-dismiss="modal">Cerrar</button>
                                                                    <button type="submit" onclick="
                                                                    emitirEliminar(event,{{ $cobro->id  }})"
                                                                        class="btn btn-danger">Eliminar</button>

                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>

                                                @endcan

                                            </div>

                                        </td>



                                    </tr>

                                    @empty

                                    <td colspan="8" class="text-center">No hay cobros particulares pendientes</td>

                                    @endforelse

                                </tbody>



                            </table>
                        </div>


                    </div>

                </div>

            </div>





        </div>

    </div>
</div>
<script>
    function emitirPagar(e, id){
        e.preventDefault();
        let fecha_cobro = document.getElementById('fecha_'+id)
        let monto_cobro = document.getElementById('monto_cobro_'+id)
        Livewire.dispatch('listenersPagar', {
             cobro: id,
             fecha_cobro:fecha_cobro.value,
             monto_cobro:Number(monto_cobro.value)})
    }
    function emitirExonerar(e, id){
        e.preventDefault();
        // let payment_mehtod = document.getElementById('payment_method_id')
        let observaciones = document.getElementById('observaciones_'+id)
        Livewire.dispatch('listenersExonerar', {
             cobro: id,
             observaciones : observaciones.value
            //  payment_method_id:Number(payment_mehtod.value),
            //  monto_cobro:Number(monto_cobro.value)
            })
    }
    function emitirEliminar(e, id){
        e.preventDefault();
        // let payment_mehtod = document.getElementById('payment_method_id')
        // let observaciones = document.getElementById('observaciones')
        Livewire.dispatch('listenersEliminar', {
             cobro: id,
            //  observaciones : observaciones.value
            //  payment_method_id:Number(payment_mehtod.value),
            //  monto_cobro:Number(monto_cobro.value)
            })
    }
</script>
