<div>
    @section('title', 'Ingreso mensual')

    <div class="container pt-2 d-flex flex-column">

        <header class="mb-4">
            <h1 class="text-center h1">Ingreso mensual - </h1>
        </header>

        {{-- @include('livewire.plan.modal-detalle') --}}

        <div class="table-responsive d-flex flex-column min-vh-100 align-items-end mt-40">
            <input class="form-control list-search mw-300px mb-5" wire:model.live="search" type="search"
                placeholder="Search">
            <table class="table">
                <thead>
                    <tr>
                        <th scope="col" class="text-center">#</th>
                        <th scope="col" class="text-center">Cliente</th>
                        <th scope="col" class="text-center">Concepto</th>
                        <th scope="col" class="text-center">Fecha</th>
                        <th scope="col" class="text-center">Monto</th>
                        {{-- <th scope="col" class="text-center">Acción</th> --}}
                    </tr>
                </thead>
                <tbody>
                    @forelse ($cobros as $cobro)
                    <tr>
                        <td>{{ $cobro->id }}</td>
                        <td>{{ $cobro->cliente->getClientName() }}</td>
                        <td>{{ $cobro->concepto }}</td>
                        <td>{{ $cobro->fecha_de_cobro }}</td>
                        <td>$ @money($cobro->monto )</td>
                        {{--
                        <td class="text-center">
                            <div class="dropdown">
                                <button class="btn btn-outline-primary" type="button" data-bs-toggle="dropdown"
                                    aria-expanded="false">
                                    <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 448 512">
                                        <!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. -->
                                        <path fill="currentColor" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="1"
                                            d="M0 96C0 78.3 14.3 64 32 64H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 128 0 113.7 0 96zM0 256c0-17.7 14.3-32 32-32H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32zM448 416c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32s14.3-32 32-32H416c17.7 0 32 14.3 32 32z" />
                                    </svg>
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item"
                                            href="{{ route('cobros.edit', $plan->uuid) }}">Editar</a></li>
                                    <li><button class="dropdown-item"
                                            wire:click="detail('{{ $plan->uuid }}')">Detalle</button>
                                    </li>
                                    <li><button class="dropdown-item"
                                            wire:click="confirmDelete('{{ $plan->uuid }}')">Eliminar</button>
                                    </li>
                                </ul>
                            </div>
                        </td>
                        --}}
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center">No existen registros</td>
                    </tr>
                    @endforelse

                    <tr>
                        <td colspan="4" class="text-center">Total</td>
                        <td>$ @money($cobros->sum('monto'))</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <div class="d-flex justify-content-center">
        {{ $cobros->links() }}
    </div>
</div>