<div>
    @section('title', 'Mikrotiks')

    <div class="container pt-2 d-flex flex-column">

        <header class="mb-4">
            <h1 class="text-center h1">Mikrotiks</h1>
        </header>

        <a class="btn btn-primary align-self-end mb-4" href="{{ route('mikrotiks.create') }}">Agregar</a>

        <button x-on:show-detail.window="document.querySelector('[data-bs-target=\'#detailMikrotikModal\']').click()"
            type="button" data-bs-toggle="modal" data-bs-target="#detailMikrotikModal" class="d-none"></button>

        <div wire:ignore.self class="modal fade" id="detailMikrotikModal" tabindex="-1"
            aria-labelledby="detailMikrotikModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="modal-title" id="detailMikrotikModalLabel">{{ $modalTitle }}</h3>
                        <button x-on:hide-modal.window="document.getElementById('btn-close-modal-register').click();"
                            id="btn-close-modal-register" type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="col">
                            <!-- Card -->
                            <div class="border-0 scroll-mt-3">
                                <div class="row mb-6">
                                    <h3 class="mb-2">Información General</h3>
                                    <div class="col-sm-6 col-lg-4">
                                        <div>
                                            <label for="fullName" class="col-form-label">Nombre</label>
                                        </div>

                                        <div>
                                            <output class="form-control" id="fullName">
                                                {{ $detailData->nombre }}
                                            </output>
                                        </div>
                                    </div> <!-- / .row -->
                                    <div class="col-sm-6 col-lg-4">
                                        <div>
                                            <label for="fullName" class="col-form-label">IP</label>
                                        </div>

                                        <div>
                                            <output class="form-control" id="fullName">
                                                {{ $detailData->ip }}
                                            </output>
                                        </div>
                                    </div> <!-- / .row -->
                                    <div class="col-sm-6 col-lg-4">
                                        <div>
                                            <label for="fullName" class="col-form-label">Serial</label>
                                        </div>

                                        <div>
                                            <output class="form-control" id="fullName">
                                                {{ $detailData->serial }}
                                            </output>
                                        </div>
                                    </div> <!-- / .row -->
                                    <div class="col-sm-6 col-lg-4">
                                        <div>
                                            <label for="fullName" class="col-form-label">Identify</label>
                                        </div>

                                        <div>
                                            <output class="form-control" id="fullName">
                                                {{ $detailData->identify }}
                                            </output>
                                        </div>
                                    </div> <!-- / .row -->
                                    <div class="col-sm-6 col-lg-4">
                                        <div>
                                            <label for="fullName" class="col-form-label">Modelo</label>
                                        </div>

                                        <div>
                                            <output class="form-control" id="fullName">
                                                {{ $detailData->modelo?->nombre }}
                                            </output>
                                        </div>
                                    </div> <!-- / .row -->
                                    <div class="col-sm-6 col-lg-4">
                                        <div>
                                            <label for="fullName" class="col-form-label">VPN User</label>
                                        </div>

                                        <div>
                                            <output class="form-control" id="fullName">
                                                {{ $detailData->vpn_user }}
                                            </output>
                                        </div>
                                    </div> <!-- / .row -->
                                    <div class="col-sm-6 col-lg-4">
                                        <div>
                                            <label for="fullName" class="col-form-label">VPN Password</label>
                                        </div>

                                        <div>
                                            <output class="form-control" id="fullName">
                                                {{ $detailData->vpn_password }}
                                            </output>
                                        </div>
                                    </div> <!-- / .row -->
                                    <div class="col-sm-6 col-lg-4">
                                        <div>
                                            <label for="fullName" class="col-form-label">VPN Server</label>
                                        </div>

                                        <div>
                                            <output class="form-control" id="fullName">
                                                {{ $detailData->vpn_server }}
                                            </output>
                                        </div>
                                    </div> <!-- / .row -->
                                    <div class="col-sm-6 col-lg-4">
                                        <div>
                                            <label for="fullName" class="col-form-label">ETH Corte 1</label>
                                        </div>

                                        <div>
                                            <output class="form-control" id="fullName">
                                                {{ $detailData->ethr_corte1 }}
                                            </output>
                                        </div>
                                    </div> <!-- / .row -->
                                    <div class="col-sm-6 col-lg-4">
                                        <div>
                                            <label for="fullName" class="col-form-label">ETH Corte 2</label>
                                        </div>

                                        <div>
                                            <output class="form-control" id="fullName">
                                                {{ $detailData->ethr_corte2 }}
                                            </output>
                                        </div>
                                    </div> <!-- / .row -->
                                    <div class="col-sm-6 col-lg-4">
                                        <div>
                                            <label for="fullName" class="col-form-label">Usuario</label>
                                        </div>

                                        <div>
                                            <output class="form-control" id="fullName">
                                                {{ $detailData->usuario }}
                                            </output>
                                        </div>
                                    </div> <!-- / .row -->
                                    <div class="col-sm-6 col-lg-4">
                                        <div>
                                            <label for="fullName" class="col-form-label">Clave</label>
                                        </div>

                                        <div>
                                            <output class="form-control" id="fullName">
                                                {{ $detailData->clave }}
                                            </output>
                                        </div>
                                    </div> <!-- / .row -->
                                </div>
                                <div class="row">
                                    <h3 class="mb-2">Protocolos</h3>
                                    @if($detailData->protocolos)
                                    @foreach ($detailData->protocolos as $protocolo)
                                    <div class="col-4 col-lg-3">
                                        <output class="form-control m-2">
                                            {{ $protocolo['protocolo'] }}: {{ $protocolo['pivot']['puerto'] }}
                                        </output>
                                    </div>
                                    @endforeach
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="table-responsive d-flex flex-column min-vh-100 align-items-end mt-40">
            <input class="form-control list-search mw-300px mb-5" wire:model.live="search" type="search"
                placeholder="Search">
            <table class="table">
                <thead>
                    <tr>
                        <th scope="col" class="text-center">Nombre</th>
                        <th scope="col" class="text-center">IP</th>
                        <th scope="col" class="text-center">Serial</th>
                        <th scope="col" class="text-center">Identify</th>
                        <th scope="col" class="text-center">Acción</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($mikrotiks as $mikrotik)
                    <tr>
                        <td>{{ $mikrotik->nombre }}</td>
                        <td class="text-center">{{ $mikrotik->ip }}</td>
                        <td class="text-center">{{ $mikrotik->serial }}</td>
                        <td class="text-center">{{ $mikrotik->identify }}</td>
                        <td class="text-center">
                            <div class="dropdown">
                                <button class="btn btn-outline-primary" type="button" data-bs-toggle="dropdown"
                                    aria-expanded="false">
                                    <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 448 512">
                                        <!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. -->
                                        <path fill="currentColor" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="1"
                                            d="M0 96C0 78.3 14.3 64 32 64H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 128 0 113.7 0 96zM0 256c0-17.7 14.3-32 32-32H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32zM448 416c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32s14.3-32 32-32H416c17.7 0 32 14.3 32 32z" />
                                    </svg>
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item"
                                            href="{{ route('mikrotiks.edit', $mikrotik->uuid) }}">Editar</a></li>
                                    <li><button class="dropdown-item"
                                            wire:click="detail('{{ $mikrotik->uuid }}')">Detalle</button></li>
                                    <li><button class="dropdown-item"
                                            wire:click="confirmDelete('{{ $mikrotik->uuid }}')">Eliminar</button>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="text-center">No existen registros</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

    </div>
    <div class="d-flex justify-content-center">
        {{ $mikrotiks->links() }}
    </div>
</div>