<div>
    @section('title', 'Modelos Mikrotiks')

    <div class="container pt-2 d-flex flex-column">

        <header class="mb-4">
            <h1 class="text-center h1">Modelos Mikrotiks</h1>
        </header>

        <button x-on:show-modal.window="document.querySelector('[data-bs-target=\'#registerModal\']').click()"
            type="button" class="btn btn-primary align-self-end mb-4" data-bs-toggle="modal"
            data-bs-target="#registerModal">
            Agregar
        </button>

        <div wire:ignore.self class="modal fade" id="registerModal" tabindex="-1" aria-labelledby="registerModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form wire:submit="save">
                        <div class="modal-header">
                            <h3 class="modal-title" id="registerModalLabel">{{ $modalTitle }}</h3>
                            <button
                                x-on:hide-modal.window="document.getElementById('btn-close-modal-register').click();"
                                id="btn-close-modal-register" type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div>
                                <label class="form-label" for="nombre">Nombre</label>
                                <input id=nombre type="text" class="form-control" wire:model="nombre">
                                <small class="text-danger">
                                    @error('nombre')
                                    {{ $message }}
                                    @enderror
                                </small>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" x-on:click="$wire.cancel()" class="btn btn-light"
                                data-bs-dismiss="modal">Cancelar</button>
                            <button type="submit" class="btn btn-primary btn-send">Guardar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="table-responsive d-flex flex-column min-vh-100 align-items-end mt-40">
            <input class="form-control list-search mw-300px mb-5" wire:model.live="search" type="search"
                placeholder="Search">
            <table class="table">
                <thead>
                    <tr>
                        <th scope="col" class="text-center">Nombre</th>
                        <th scope="col" class="text-center">Acción</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($modelos as $modelo)
                    <tr>
                        <td class="text-center">{{ $modelo->nombre }}</td>
                        <td class="text-center">
                            <div class="dropdown">
                                <button class="btn btn-outline-primary" type="button" data-bs-toggle="dropdown"
                                    aria-expanded="false">
                                    <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 448 512">
                                        <!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. -->
                                        <path fill="currentColor" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="1"
                                            d="M0 96C0 78.3 14.3 64 32 64H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 128 0 113.7 0 96zM0 256c0-17.7 14.3-32 32-32H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32zM448 416c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32s14.3-32 32-32H416c17.7 0 32 14.3 32 32z" />
                                    </svg>
                                </button>
                                <ul class="dropdown-menu">
                                    <li><button class="dropdown-item"
                                            wire:click="edit('{{ $modelo->uuid }}')">Editar</button></li>
                                    <li><button class="dropdown-item"
                                            wire:click="confirmDelete('{{ $modelo->uuid }}')">Eliminar</button></li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="3" class="text-center">No existen registros</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

    </div>
    <div class="d-flex justify-content-center">
        {{ $modelos->links() }}
    </div>
</div>