<div class="table-responsive d-flex flex-column min-vh-100 align-items-end mt-40">
    <input class="form-control list-search mw-300px mb-5" wire:model.live="search" type="search"
        placeholder="Search">
    <table class="table">
        <thead>
            <tr>
                <th scope="col" class="text-center">Nombres</th>
                <th scope="col" class="text-center">Cédula</th>
                <th scope="col" class="text-center">Teléfono</th>
                <th scope="col" class="text-center">Correo</th>
                <th scope="col" class="text-center">Acción</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($personas as $persona)
                <tr>
                    <td>
                        {{ $persona->nombres }}
                    </td>
                    <td class="text-center">{{ $persona->cedula }}</td>
                    <td class="text-center">{{ $persona->telefono }}</td>
                    <td class="text-center">{{ $persona->correo }}</td>
                    <td class="text-center">
                        <div class="dropdown">
                            <button class="btn btn-outline-primary" type="button" data-bs-toggle="dropdown"
                                aria-expanded="false">
                                <svg xmlns="http://www.w3.org/2000/svg" height="1em"
                                    viewBox="0 0 448 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. -->
                                    <path fill="currentColor" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="1"
                                        d="M0 96C0 78.3 14.3 64 32 64H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 128 0 113.7 0 96zM0 256c0-17.7 14.3-32 32-32H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32zM448 416c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32s14.3-32 32-32H416c17.7 0 32 14.3 32 32z" />
                                </svg>
                            </button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="{{ route('personas.edit', $persona->uuid) }}">Editar</a></li>
                                <li><button class="dropdown-item" wire:click="detail('{{ $persona->uuid }}')">Detalle</button></li>
                                <li><button class="dropdown-item"
                                        wire:click="confirmDelete('{{ $persona->uuid }}')">Eliminar</button>
                                </li>
                            </ul>
                        </div>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="5" class="text-center">No existen registros</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
