<div>
    @section('title', $pageTitle)

    <div class="col">
        <form wire:submit="save">
            <!-- Card -->
            <div class="card border-0 scroll-mt-3" id="basicInformationSection">
                <div class="card-header">
                    <h2 class="h3 mb-0 text-center">{{ $pageTitle }}</h2>
                </div>

                <div class="card-body row mb-4">
                    {{-- Nombre del plan --}}
                    <div class="col-md-12 mb-4">
                        <label for="nombre" class="form-label">Nombre</label>
                        <input class="form-control" type="text" id="nombre" name="nombre" wire:model="form.nombre"
                            placeholder="Ingrese el nombre del plan" required>
                        <small class="text-danger">
                            @error('form.nombre')
                            {{ $message }}
                            @enderror
                        </small>
                    </div>
                    {{--Costo --}}
                    <div class="col-md-4 mb-4">
                        <label for="costo" class="form-label">Costo</label>
                        <input class="form-control" type="number" id="costo" name="costo" wire:model="form.costo"
                            placeholder="Ingrese el costo del plan" min="0" step="0.01" required>
                        <small class="text-danger">
                            @error('form.costo')
                            {{ $message }}
                            @enderror
                        </small>

                    </div>
                    {{-- Precio --}}
                    <div class="col-md-4 mb-4">
                        <label for="precio" class="form-label">Precio</label>
                        <input class="form-control" type="number" id="precio" name="precio" wire:model="form.precio"
                            placeholder="Ingrese el precio del plan" min="0" step="0.01" required>
                        <small class="text-danger">
                            @error('form.precio')
                            {{ $message }}
                            @enderror
                        </small>
                    </div>

                    {{-- Provedor --}}
                    <div class="col-md-4 mb-4 col-sm-6 col-lg-4">
                        <label for="proveedor_id" class="form-label">Proveedor</label>

                        <select class="form-select" name="proveedor_id" id="proveedor_id"
                            wire:model.live="form.proveedor_id" required>
                            <option value="" selected>Seleccione una opcion</option>
                            @foreach ($proveedores as $proveedor)
                            <option value="{{ $proveedor->id }}">
                                {{ $proveedor->id.'-'.$proveedor->empresa->razon }}
                            </option>
                            @endforeach
                        </select>
                        <small class="text-danger">
                            @error('form.proveedor_id')
                            {{ $message }}
                            @enderror
                        </small>
                    </div>


                    <div class="d-flex justify-content-end gap-2">
                        <!-- Button -->
                        @if ($uuid)
                        <button type="button" wire:click="resetForm" class="btn btn-danger">Reiniciar</button>
                        @else
                        <button type="button" wire:click="cleanForm" class="btn btn-danger">Limpiar</button>
                        @endif
                        <button id="save_btn" type="submit" class="btn btn-primary">{{ __('Save') }}</button>
                    </div>
                </div>

            </div>

        </form>

    </div>

</div>

{{-- <script>
    const button =document.querySelector('#save_btn');
button.addEventListener('click', () => {


    setTimeout(() => {
        const url = `{{ route('planes.index') }}`;
        window.location.href = url; // Replace with the desired URL
  }, 2000); // Delay in milliseconds (5000 = 5 seconds)
});


</script> --}}