<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de cobros</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/css/bootstrap.min.css"
        integrity="sha384-zCbKRCUGaJDkqS1kPbPX4m9Gv8iQgA70ZvCKmWl5+h8ACV4Q5Nlt+MCYL9WhW5" crossorigin="anonymous">

    <link rel="preload" as="style"
        href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700;800&display=swap">
    <link rel="stylesheet" media="print" onload="this.onload=null;this.removeAttribute('media');"
        href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700;800&display=swap">
    <style>
        /* body {
            background-image: url('{{ public_path().$logo }}');
            background-repeat: no-repeat;
            background-size: cover;
            background-position: center;
            background-size: 350px 150px;

        } */

        .large-font {
            font-size: 1.5rem;
            /* Ajusta el tamaño según sea necesario */
        }

        .medium-font {
            font-size: 0.8rem;
            /* Ajusta el tamaño según sea necesario */
        }

        .small-font {
            font-size: 0.6rem;
            /* Ajusta el tamaño según sea necesario */
        }

        .text-vertical-center {
            display: flex;
            align-items: center;
            /* Centra verticalmente */
            height: 100px;
            /* Ajusta la altura según sea necesario */
        }

        body {
            margin: 0px;
            padding: 0px;
            /* Ajusta el valor según sea necesario */
        }

        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-image: url('{{ public_path().$logo }}');
            background-repeat: no-repeat;
            background-size: cover;
            background-position: center;
            background-size: 400px 120px;
            opacity: 0.1;
            /* Ajusta la opacidad aquí */
            z-index: -1;
            /* Coloca el pseudo-elemento detrás del contenido */
        }
    </style>
</head>

<body>
    <div class="">
        <div class="row medium-font">
            <div class="col col-md-6">
                {{-- <img src="{{ public_path().$logo }}" class="water-mark" width="160" height="50"> --}}
                <img src="{{ public_path().$logo }}" class="mb-3" width="200" height="65">

            </div>
            <div class="col col-md-2  opacity-full">
                <p class="large-font mb-3 font-weight-bold text-center">Reporte de cobros</p>
                {{-- <p> CloudSat</p> --}}
                <p>
                    {{-- <span class="font-weight-bold"> Vendedor: </span>{{ $cobros[0]->vendedor }} --}}
                    <br><strong>Periodo:</strong>{{ $fechas['fecha_desde'].' - '.$fechas['fecha_hasta'] }}
                    <br><strong>Fecha de generación:</strong> {{ $fechas['fecha_generacion'] }}
                </p>
            </div>
        </div>


        <div class="row col-md-12">
            <table class="table table-striped table-bordered small-font">
                <thead>
                    {{-- <tr>
                        <th colspan="4">{{}}</th>
                    </tr> --}}
                    <tr class="align-middle">
                        <th class="align-middle text-center" style="width: 15%;">Remota</th>
                        <th class="align-middle text-center" style="width: 15%;">KIT</th>
                        <th class="align-middle text-center" style="width: 7%;">Plan costo</th>
                        <th class="align-middle text-center" style="width: 7%;">Plan venta</th>
                        <th class="align-middle text-center" style="width: 5%;">Dia de pago </th>
                        <th class="align-middle text-center" style="width: 7%;">Pago cliente</th>
                        <th class="align-middle text-center" style="width: 10%;">Metodo pago</th>
                        <th class="align-middle text-center" style="width: 7%;">Comision</th>
                        <th class="align-middle text-center" style="width: 7%;">Utilidad</th>
                    </tr>
                </thead>
                <tbody>

                    {{-- <tr>
                        Enero
                    </tr> --}}
                    @forelse ($cobros as $cobro)
                    <tr>
                        <td>{{ $cobro->remota->equipo }}</td>
                        <td>{{ $cobro->remota->kit_serial }}</td>
                        <td class="text-right">$@money($cobro->remota->plan->costo)</td>
                        <td class="text-right">$@money( $cobro->remota->costo)</td>
                        <td>{{ $cobro->fecha_pago }}</td>
                        <td class="text-right">$@money($cobro->monto)</td>
                        <td>{{$cobro->paymentMethod->name ?? 'NR' }}</td>
                        <td class="text-right">$@money(str_contains($cobro->concepto, 'Pago completo') ? $cobro->remota->comision : 0)</td>
                        <td class="text-right">$@money($cobro->utilidad)</td>
                    </tr>


                    @empty

                    @endforelse

                </tbody>
                <tfoot>
                    <tr>
                        <td class="bg-primary text-white font-weight-bold medium-font" colspan="2">Total</td>
                        <td class="text-right">$@money($cobros->sum('remota.plan.costo'))</td>
                        <td class="text-right">$@money($cobros->sum('remota.costo'))</td>
                        <td></td>
                        <td class="text-right">$@money($cobros->sum('monto'))</td>
                        <td></td>
                        <td class="text-right">$@money($cobros->sum(function($cobro) {
                            return str_contains($cobro->concepto, 'Pago completo') ? $cobro->remota->comision : 0;
                        }))</td>
                        <td class="text-right">$@money($cobros->sum('utilidad'))</td> <!-- Total de Utilidad -->
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.slim.min.js"
        integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-fQybjgWLrvvR+DLTsDeeXhc01hgwTGp/n5+y0tGvFCRQjZhjgrhntLZnjxDzfbT" crossorigin="anonymous">
    </script>
</body>

</html>