<?php

use App\Http\Controllers\RemotasController;
use App\Models\Plan;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get(
    'planes/proveedor/{proveedor?}',
    function ($proveedor) {
        $planes = Plan::where('proveedor_id', $proveedor)->get();

        return response()->json($planes);
    }
)->name('planes.porProveedor');


Route::get('/getFechasDeCuentas', [RemotasController::class, 'getFechasDeCuentas']);
