<?php
$configuracion_route = "configuraciones.index";
$user_route = "users.index";
$roles_route = "roles.index";
$permissions_route = "permissions.index";
$payment_methods_route = "payment_methods.index";

// Agrupar rutas para secciones específicas
$menu_config_routes = [$configuracion_route, $user_route, $roles_route, $permissions_route,$payment_methods_route];
$menu_controls_routes = [$payment_methods_route];
?>

<li class="nav-item dropdown">
    <a class="<?php echo \Illuminate\Support\Arr::toCssClasses(["nav-link", "active"=> is_current_route($menu_config_routes)]); ?>"
        href="#configCollapse"
        data-bs-toggle="collapse"
        role="button"
        aria-expanded="<?php echo e(in_array(Route::currentRouteName(), $menu_config_routes) ? 'true' : 'false'); ?>"
        aria-controls="configCollapse">
        <svg xmlns="http://www.w3.org/2000/svg" class="nav-link-icon" viewBox="0 0 24 24" height="18" width="18">
            <g>
                <g>
                    <path d="M10.5,11.25a5.25,5.25,0,0,1,0-10.5" fill="none" stroke="currentColor"
                        stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
                    <path d="M.75,23.25A9.76,9.76,0,0,1,10.5,13.5" fill="none" stroke="currentColor"
                        stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
                </g>
                <g>
                    <g>
                        <line x1="15.62" y1="3.88" x2="17.25" y2="2.25" fill="none" stroke="currentColor"
                            stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
                        <line x1="15.62" y1="8.12" x2="17.25" y2="9.75" fill="none" stroke="currentColor"
                            stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
                        <path d="M13.5,3a3,3,0,0,1,0,6" fill="none" stroke="currentColor" stroke-linecap="round"
                            stroke-linejoin="round" stroke-width="1.5" />
                        <line x1="13.5" y1="3" x2="13.5" y2="0.75" fill="none" stroke="currentColor"
                            stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
                        <line x1="13.5" y1="9" x2="13.5" y2="11.25" fill="none" stroke="currentColor"
                            stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
                        <line x1="16.5" y1="6" x2="18.75" y2="6" fill="none" stroke="currentColor"
                            stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
                    </g>
                    <g>
                        <path
                            d="M23.25,23.25v-1.5h-2.4a7.42,7.42,0,0,0-1.09-2.64l1.69-1.69L19.33,15.3,17.64,17A7.42,7.42,0,0,0,15,15.9V13.5H13.5"
                            fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                            stroke-width="1.5" />
                        <path d="M13.5,19.5a3.75,3.75,0,0,1,3.75,3.75" fill="none" stroke="currentColor"
                            stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" />
                    </g>
                </g>
            </g>
        </svg>
        <span>Administrador</span>
    </a>

    <div class="<?php echo e(in_array(Route::currentRouteName(), $menu_config_routes) ? 'collapse show' : 'collapse'); ?>"
        id="configCollapse">
        <ul class="nav flex-column">
            
            <li class="nav-item">
                <a href="<?php echo e(route($configuracion_route)); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(["nav-link", "active"=>
                    is_current_route([$configuracion_route])]); ?>">
                    <span>Configuraciones</span>
                </a>
            </li>
            
            <li class="nav-item">
                <a href="<?php echo e(route($user_route)); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(["nav-link", "active"=> is_current_route([$user_route])]); ?>">
                    <span>Usuarios</span>
                </a>
            </li>
            
            <li class="nav-item">
                <a href="<?php echo e(route($roles_route)); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(["nav-link", "active"=> is_current_route([$roles_route])]); ?>">
                    <span>Roles</span>
                </a>
            </li>
            
            <li class="nav-item">
                <a href="<?php echo e(route($permissions_route)); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(["nav-link", "active"=>
                    is_current_route([$permissions_route])]); ?>">
                    <span>Permisos</span>
                </a>
            </li>

            
            <li class="nav-item">
                <a class="<?php echo \Illuminate\Support\Arr::toCssClasses(["nav-link", "active"=> is_current_route($menu_controls_routes)]); ?>"
                    href="#configCollapseControls"
                    data-bs-toggle="collapse"
                    role="button"
                    aria-expanded="<?php echo e(in_array(Route::currentRouteName(), $menu_controls_routes) ? 'true' : 'false'); ?>"
                    aria-controls="configCollapseControls">
                    <i class="fas fa-gear nav-link-icon" style="font-size: 14px;"></i>
                    <span>Controles</span>
                </a>
                <div class="<?php echo e(in_array(Route::currentRouteName(), $menu_controls_routes) ? 'collapse show' : 'collapse'); ?>"
                    id="configCollapseControls">
                    <ul class="nav flex-column">
                        
                        <li class="nav-item">
                            <a href="<?php echo e(route($payment_methods_route)); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(["nav-link", "active"=>
                                is_current_route([$payment_methods_route])]); ?>">
                                <span>Métodos de pago</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>
        </ul>
    </div>
</li><?php /**PATH /var/www/vhosts/cloudsatllc.com/portal.cloudsatllc.com/resources/views/layouts/sidebar/items/configuracion.blade.php ENDPATH**/ ?>