<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Recibo de Pago - <?php echo e($numero_recibo); ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Arial', sans-serif;
            font-size: 12px;
            color: #333;
            padding: 20px;
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
            border: 2px solid #2c3e50;
            padding: 30px;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 3px solid #3498db;
            padding-bottom: 20px;
        }

        .header h1 {
            color: #2c3e50;
            font-size: 28px;
            margin-bottom: 5px;
            text-transform: uppercase;
        }

        .header h2 {
            color: #3498db;
            font-size: 20px;
            margin-bottom: 10px;
        }

        .header p {
            color: #7f8c8d;
            font-size: 11px;
            line-height: 1.6;
        }

        .recibo-info {
            background-color: #ecf0f1;
            padding: 15px;
            margin-bottom: 25px;
            border-radius: 5px;
        }

        .recibo-info table {
            width: 100%;
        }

        .recibo-info td {
            padding: 5px;
        }

        .recibo-info .label {
            font-weight: bold;
            color: #2c3e50;
            width: 40%;
        }

        .recibo-info .value {
            color: #34495e;
        }

        .section-title {
            background-color: #3498db;
            color: white;
            padding: 10px;
            margin-top: 20px;
            margin-bottom: 15px;
            font-size: 14px;
            font-weight: bold;
            text-transform: uppercase;
        }

        .info-block {
            margin-bottom: 20px;
        }

        .info-block table {
            width: 100%;
            border-collapse: collapse;
        }

        .info-block td {
            padding: 8px;
            border-bottom: 1px solid #ecf0f1;
        }

        .info-block .label {
            font-weight: bold;
            color: #2c3e50;
            width: 35%;
        }

        .info-block .value {
            color: #34495e;
        }

        .monto-total {
            background-color: #27ae60;
            color: white;
            padding: 20px;
            text-align: center;
            margin: 25px 0;
            border-radius: 5px;
        }

        .monto-total .label {
            font-size: 16px;
            margin-bottom: 10px;
        }

        .monto-total .cantidad {
            font-size: 32px;
            font-weight: bold;
        }

        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 2px solid #ecf0f1;
            text-align: center;
        }

        .firma {
            margin-top: 60px;
            text-align: center;
        }

        .firma-linea {
            width: 300px;
            border-top: 2px solid #2c3e50;
            margin: 0 auto 10px auto;
        }

        .notas {
            background-color: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px;
            margin-top: 20px;
            font-size: 11px;
            color: #856404;
        }

        .watermark {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 80px;
            color: rgba(52, 152, 219, 0.1);
            z-index: -1;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="watermark">PAGADO</div>
    
    <div class="container">
        <!-- Header -->
        <div class="header">
            <h1><?php echo e($empresa['nombre']); ?></h1>
            <h2>RECIBO DE PAGO</h2>
            <p>
                RIF: <?php echo e($empresa['rif']); ?><br>
                <?php echo e($empresa['direccion']); ?><br>
                Teléfono: <?php echo e($empresa['telefono']); ?> | Email: <?php echo e($empresa['email']); ?>

            </p>
        </div>

        <!-- Información del Recibo -->
        <div class="recibo-info">
            <table>
                <tr>
                    <td class="label">Nº de Recibo:</td>
                    <td class="value"><strong><?php echo e($numero_recibo); ?></strong></td>
                    <td class="label">Fecha de Pago:</td>
                    <td class="value"><strong><?php echo e(is_string($fecha_pago) ? $fecha_pago : \Carbon\Carbon::parse($fecha_pago)->format('d/m/Y')); ?></strong></td>
                </tr>
            </table>
        </div>

        <!-- Información del Cliente -->
        <div class="section-title">Datos del Cliente</div>
        <div class="info-block">
            <table>
                <tr>
                    <td class="label">Cliente:</td>
                    <td class="value"><?php echo e($cliente->getClientName()); ?></td>
                </tr>
                <?php if($cliente->clientable_type === 'App\Models\Persona'): ?>
                <tr>
                    <td class="label">Cédula/RIF:</td>
                    <td class="value"><?php echo e($cliente->persona->cedula ?? 'N/A'); ?></td>
                </tr>
                <?php else: ?>
                <tr>
                    <td class="label">RIF:</td>
                    <td class="value"><?php echo e($cliente->empresa->rif ?? 'N/A'); ?></td>
                </tr>
                <?php endif; ?>
                <?php if($cobro->remota): ?>
                <tr>
                    <td class="label">Equipo/Remota:</td>
                    <td class="value"><?php echo e($equipo); ?></td>
                </tr>
                <?php endif; ?>
            </table>
        </div>

        <!-- Detalle del Pago -->
        <div class="section-title">Detalle del Pago</div>
        <div class="info-block">
            <table>
                <tr>
                    <td class="label">Concepto:</td>
                    <td class="value"><?php echo e($concepto); ?></td>
                </tr>
                <tr>
                    <td class="label">Método de Pago:</td>
                    <td class="value"><?php echo e($metodo_pago); ?></td>
                </tr>
                <?php if($cobro->observaciones): ?>
                <tr>
                    <td class="label">Observaciones:</td>
                    <td class="value"><?php echo e($cobro->observaciones); ?></td>
                </tr>
                <?php endif; ?>
            </table>
        </div>

        <!-- Monto Total -->
        <div class="monto-total">
            <div class="label">MONTO PAGADO</div>
            <div class="cantidad">$<?php echo e(number_format($monto, 2, ',', '.')); ?></div>
        </div>

        <?php if($cobro->concepto && str_contains(strtolower($cobro->concepto), 'abono')): ?>
        <div class="notas">
            <strong>Nota:</strong> Este recibo corresponde a un pago parcial (abono). 
            El saldo pendiente será registrado en futuras transacciones.
        </div>
        <?php endif; ?>

        <!-- Firma -->
        <div class="firma">
            <div class="firma-linea"></div>
            <p><strong>Firma Autorizada</strong></p>
            <p style="font-size: 10px; color: #7f8c8d;"><?php echo e($empresa['nombre']); ?></p>
        </div>

        <!-- Footer -->
        <div class="footer">
            <p style="font-size: 10px; color: #95a5a6;">
                Este es un recibo de pago generado electrónicamente.<br>
                Para cualquier consulta, comuníquese con nosotros.<br>
                <strong>Fecha de emisión:</strong> <?php echo e(\Carbon\Carbon::now()->format('d/m/Y H:i:s')); ?>

            </p>
        </div>
    </div>
</body>
</html>

<?php /**PATH /var/www/vhosts/cloudsatllc.com/portal.cloudsatllc.com/resources/views/pdf/recibo-cobranza.blade.php ENDPATH**/ ?>