<?php $__env->startSection('title',$title); ?>

<?php $__env->startSection('header', $title); ?>

<?php $__env->startSection('header-text'); ?>
Listado general de remotas satelitales.
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header-actions'); ?>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('remotas_satelital.create')): ?>
<a class="btn btn-primary align-self-end mb-4" href="<?php echo e(route('remotas.create')); ?>">Agregar</a>
<?php endif; ?>
<?php ($statuses = App\Models\Remota::getStatuses()); ?>
<div class="d-flex align-items-center gap-2">
    <label for="status-filter" class="mb-0">Estado:</label>
    <select id="status-filter" class="form-select form-select-sm" style="max-width: 200px;">
        <option value="">Todos</option>
        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($status); ?>"><?php echo e($status); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
    </select>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('table-head'); ?>
<tr>
    <th scope="col" class="text-center">#</th>
    <th scope=" col" class="text-center col-20">Equipo</th>
    <th scope=" col" class="text-center col-20">Cliente</th>
    <th scope=" col" class="text-center col-5 ">Estado</th>
    <th scope=" col" class="text-center  d-none">Serial antena</th>
    <th scope=" col" class="text-center col-10 d-none d-md-table-cell">Kit</th>
    <th scope=" col" class="text-center col-10">Dia Corte</th>
    <th scope=" col" class="text-center d-none d-sm-table-cell">Plan</th>
    <th scope=" col" class="text-center d-none d-sm-table-cell">Vendedor</th>
    <th scope=" col" class="text-center ">Acciones</th>
</tr>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('table-body'); ?>
<!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
<tr>
    <th class="text-center"><?php echo e($item->id); ?></th>
    <td class="text-left"><?php echo Str::limit($item->equipo, 30, '...'); ?></td>
    <td class="text-left"> <?php echo e($item->cliente->getClientName()); ?></td>
    <td class="text-center "><span class="badge bg-<?php echo e($item->estadoBadge); ?>"><?php echo e($item->status); ?></span></td>
    <td class="text-center d-none "><?php echo e($item->antena_serial); ?></td>
    <td class="text-center d-none d-sm d-md-table-cell"><?php echo e($item->kit_serial); ?></td>
    <td class="text-center"><?php echo e($item->fecha_corte); ?></td>
    <td class="text-left   d-none d-sm-table-cell"><?php echo Str::limit($item->plan->nombre, 30, '...'); ?></td>
    <td class="text-left d-none d-sm-table-cell"><?php echo Str::limit($item->vendedor->persona->nombres, 30, '...'); ?></td>
    <td scope="col" class="text-center d-flex justify-content-center align-items-center h-100">
        
        <div class="dropdown">
            <button class=" btn btn-outline-primary btn-xs p-3 pt-1 pb-1 me-1" type="button" data-bs-toggle="dropdown"
                aria-expanded="false">
                <i class="fa-solid fa-bars"></i>
            </button>
            <ul class="dropdown-menu">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('remotas_satelital.edit')): ?>
                <li><a class="dropdown-item" href="<?php echo e(route('remotas.edit', $item->uuid)); ?>"
                        title="Editar datos de la remoa">Editar</a></li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('remotas_satelital.show_detail')): ?>
                <li><a class="dropdown-item" target="_blank" href="<?php echo e(route('remotas.show', $item->id)); ?>">Full
                        Detalle</a></li>
                <?php endif; ?>
                

            </ul>
        </div>
        <button type="button" class="btn btn-xs btn-info p-3 pt-1 pb-1 me-1" data-bs-toggle="modal"
            data-bs-target="#ver_remotas_<?php echo e($item->uuid); ?>" title="Ver remotas">

            <i class="fa-regular fa-eye"></i>
        </button>
        <?php echo $__env->make('livewire.remota.includes.modales.show-detail', ['item' => $item], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </td>
</tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
<tr>
    <td colspan=" 5" class="text-center">No hay registros encontrados.</td>
</tr>
<?php endif; ?><!--[if ENDBLOCK]><![endif]-->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    console.log('Página cargada con éxito.');
    $(document).ready(function() {
        var selector = '.datatable';

        function bindEstadoFilter(dt) {
            $('#status-filter').off('change.remotas').on('change.remotas', function() {
                var val = $(this).val();
                // Búsqueda exacta en la columna 3 (Estado)
                dt.column(3).search(val ? '^' + val + '$' : '', true, false).draw();
            });
        }

        // Si ya existe una instancia global, la recuperamos y aplicamos el filtro
        if ($.fn.dataTable.isDataTable(selector)) {
            var table = $(selector).DataTable(); // Recupera sin re-inicializar
            bindEstadoFilter(table);
            // Exponer un segundo handle (otra referencia) sin re-inicializar
            window.remotasTable = table;
        } else {
            // Aún no está inicializada: esperamos al evento de init de la instancia global
            $(selector).one('init.dt', function() {
                var table = $(this).DataTable(); // Recupera la instancia recién creada por el init global
                bindEstadoFilter(table);
                window.remotasTable = table;
            });
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.table-page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/cloudsatllc.com/portal.cloudsatllc.com/resources/views/livewire/remota/remota-component.blade.php ENDPATH**/ ?>