<?php
$cobranzas_route = 'cobranzas.index';
$cuentas_por_cobrar_route = 'cobranzas.index';
$cobros_route = 'cobros.index';
$cobros_mensualidades_route = 'cobros_mensualidades.index';
$cobros_mensualidades_futuras_route = 'cobros_mensualidades_futuras.index';
$cobros_create_route = 'cobranzas.create';
$previsiones_de_pago_route = 'previsiones_de_pago.index';
$historial_de_cobros_route = 'cobros_historial.index';
$reporte_vendedores_route = 'reporte_vendedores.index';

$menu_cobranzas_routes = [
$cuentas_por_cobrar_route,
$cobranzas_route,
$previsiones_de_pago_route,
$historial_de_cobros_route,
$reporte_vendedores_route,
$cobros_route,
$cobros_create_route,
$cobros_mensualidades_route,
$cobros_mensualidades_futuras_route
];
?>
<li class="nav-item dropdown">
    <a class="<?php echo \Illuminate\Support\Arr::toCssClasses([ 'nav-link' , 'active'=> is_current_route($menu_cobranzas_routes),
        ]); ?>" href="#cobranzasCollapse" data-bs-toggle="collapse" role="button"
        aria-controls="cobranzasCollapse">


        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="nav-link-icon" height="18" width="18">
            <!--!Font Awesome Free 6.5.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.-->
            <path fill="#6b7a8a"
                d="M112 112c0 35.3-28.7 64-64 64V336c35.3 0 64 28.7 64 64H464c0-35.3 28.7-64 64-64V176c-35.3 0-64-28.7-64-64H112zM0 128C0 92.7 28.7 64 64 64H512c35.3 0 64 28.7 64 64V384c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V128zM176 256a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zm80-48c0 8.8 7.2 16 16 16v64h-8c-8.8 0-16 7.2-16 16s7.2 16 16 16h24 24c8.8 0 16-7.2 16-16s-7.2-16-16-16h-8V208c0-8.8-7.2-16-16-16H272c-8.8 0-16 7.2-16 16z" />
        </svg>
        <span>Cobranzas</span>
    </a>
    <div class="<?php echo e(in_array(Route::currentRouteName(), $menu_cobranzas_routes)  ? 'collapse show' : 'collapse'); ?>"
        id="cobranzasCollapse">
        <ul class="nav flex-column">
            
            


            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cobranzas.cobros_particulares.index')): ?>
            <li class="nav-item">
                <a href="<?php echo e(route($cobros_route)); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-link', 'active'=>
                    is_current_route([$cobros_route])]); ?>">
                    <span>Cobros particulares por cobrar</span>
                </a>
            </li>
            <?php endif; ?>

            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cobranzas.cobros_mensualidades.index')): ?>
            <li class="nav-item">
                <a href="<?php echo e(route($cobros_mensualidades_route)); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-link', 'active'=>
                    is_current_route([$cobros_mensualidades_route])]); ?>">
                    <span>Mensualidades por cobrar</span>
                </a>
            </li>
            <?php endif; ?>
            

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cobranzas.cobros_mensualidades_futuras.index')): ?>
            <li class="nav-item">
                <a href="<?php echo e(route($cobros_mensualidades_futuras_route)); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-link', 'active'=>
                    is_current_route([$cobros_mensualidades_futuras_route])]); ?>">
                    <span>Adelantar Mensualidades por cobrar</span>
                </a>
            </li>
            <?php endif; ?>


            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cobranzas.previsiones_de_pago.index')): ?>
            <li class="nav-item">
                <a href="<?php echo e(route($previsiones_de_pago_route)); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-link', 'active'=>
                    is_current_route([$previsiones_de_pago_route])]); ?>">
                    <span>Previsiones de pago </span>
                </a>
            </li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cobranzas.historial_de_pagos_de_cobros.index')): ?>
            
            <li class="nav-item">
                <a href="<?php echo e(route($historial_de_cobros_route)); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-link', 'active'=>
                    is_current_route([$historial_de_cobros_route])]); ?>">
                    <span>Historial de pagos</span>
                </a>
            </li>
            <?php endif; ?>
            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cobranzas.reporte_de_vendedores.index')): ?>
            <li class="nav-item">
                <a href="<?php echo e(route($reporte_vendedores_route)); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-link', 'active'=>
                    is_current_route([$reporte_vendedores_route])]); ?>">
                    <span>Reportes</span>
                </a>
            </li>
            <?php endif; ?>
        </ul>
    </div>
</li><?php /**PATH /var/www/vhosts/cloudsatllc.com/portal.cloudsatllc.com/resources/views/layouts/sidebar/items/cobranzas.blade.php ENDPATH**/ ?>