<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de cobros</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/css/bootstrap.min.css"
        integrity="sha384-zCbKRCUGaJDkqS1kPbPX4m9Gv8iQgA70ZvCKmWl5+h8ACV4Q5Nlt+MCYL9WhW5" crossorigin="anonymous">

    <link rel="preload" as="style"
        href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700;800&display=swap">
    <link rel="stylesheet" media="print" onload="this.onload=null;this.removeAttribute('media');"
        href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700;800&display=swap">
    <style>
        /* body {
            background-image: url('<?php echo e(public_path().$logo); ?>');
            background-repeat: no-repeat;
            background-size: cover;
            background-position: center;
            background-size: 350px 150px;

        } */

        .large-font {
            font-size: 1.5rem;
            /* Ajusta el tamaño según sea necesario */
        }

        .medium-font {
            font-size: 0.8rem;
            /* Ajusta el tamaño según sea necesario */
        }

        .small-font {
            font-size: 0.6rem;
            /* Ajusta el tamaño según sea necesario */
        }

        .text-vertical-center {
            display: flex;
            align-items: center;
            /* Centra verticalmente */
            height: 100px;
            /* Ajusta la altura según sea necesario */
        }

        body {
            margin: 0px;
            padding: 0px;
            /* Ajusta el valor según sea necesario */
        }

        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-image: url('<?php echo e(public_path().$logo); ?>');
            background-repeat: no-repeat;
            background-size: cover;
            background-position: center;
            background-size: 400px 120px;
            opacity: 0.1;
            /* Ajusta la opacidad aquí */
            z-index: -1;
            /* Coloca el pseudo-elemento detrás del contenido */
        }
    </style>
</head>

<body>
    <div class="">
        <div class="row medium-font">
            <div class="col col-md-6">
                
                <img src="<?php echo e(public_path().$logo); ?>" class="mb-3" width="200" height="65">

            </div>
            <div class="col col-md-2  opacity-full">
                <p class="large-font mb-3 font-weight-bold text-center">Reporte de cobros</p>
                
                <p>
                    
                    <br><strong>Periodo:</strong><?php echo e($fechas['fecha_desde'].' - '.$fechas['fecha_hasta']); ?>

                    
                </p>
            </div>
        </div>


        <div class="row col-md-12">
            <table class="table table-striped table-bordered small-font">
                <thead>
                    
                    <tr class="align-middle">
                        <th class="align-middle text-center" style="width: 20%;">Remota</th>
                        <th class="align-middle text-center" style="width: 5%; ">KIT</th>
                        <th class="align-middle text-center" style="width: 8%;">Plan costo</th>
                        <th class="align-middle text-center" style="width: 8%;">Plan venta</th>
                        <th class="align-middle text-center" style="width: 12%;">Fecha Pago y Mes</th>
                        <th class="align-middle text-center" style="width: 10%;">Monto</th>
                        <th class="align-middle text-center" style="width: 10%;">Metodo pago</th>
                        <th class="align-middle text-center" style="width: 10%;">Comision</th>
                        <th class="align-middle text-center" style="width: 10%;">Utilidad</th>
                    </tr>
                </thead>
                <tbody>

                    
                    <?php $__empty_1 = true; $__currentLoopData = $cobros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cobro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($cobro->remota->equipo); ?></td>
                        <td style="word-break: break-all; font-size: 0.6rem;"><?php echo e($cobro->remota->kit_serial); ?></td>
                        <td class="text-right">$<?php echo number_format($cobro->remota->plan->costo, 2, '.', ','); ?></td>
                        <td class="text-right">$<?php echo number_format($cobro->remota->costo, 2, '.', ','); ?></td>
                        <td class="text-center">
                            <div><?php echo e($cobro->fecha_pago); ?></div>
                            <div class="text-muted"><?php echo e(optional($cobro->cobro)->fecha ? \Carbon\Carbon::parse(optional($cobro->cobro)->fecha)->format('m/Y') : 'N/R'); ?></div>
                        </td>
                        <td class="text-right">$<?php echo number_format($cobro->monto, 2, '.', ','); ?></td>
                        <td><?php echo e($cobro->paymentMethod->name ?? 'NR'); ?></td>
                        <td class="text-right">$<?php echo number_format(str_contains($cobro->concepto, 'Pago completo') ? $cobro->remota->comision : 0, 2, '.', ','); ?></td>
                        <td class="text-right">$<?php echo number_format($cobro->utilidad, 2, '.', ','); ?></td>
                    </tr>


                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                    <?php endif; ?>

                </tbody>
                <tfoot>
                    <tr>
                        <td class="bg-primary text-white font-weight-bold medium-font" colspan="2">Total</td>
                        <td class="text-right">$<?php echo number_format($cobros->sum('remota.plan.costo'), 2, '.', ','); ?></td>
                        <td class="text-right">$<?php echo number_format($cobros->sum('remota.costo'), 2, '.', ','); ?></td>
                        <td></td>
                        <td class="text-right">$<?php echo number_format($cobros->sum('monto'), 2, '.', ','); ?></td>
                        <td></td>
                        <td class="text-right">$<?php echo number_format($cobros->sum(function($cobro) {
                            return str_contains($cobro->concepto, 'Pago completo') ? $cobro->remota->comision : 0;
                            }), 2, '.', ','); ?></td>
                        <td class="text-right">$<?php echo number_format($cobros->sum('utilidad'), 2, '.', ','); ?></td> <!-- Total de Utilidad -->
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.slim.min.js"
        integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-fQybjgWLrvvR+DLTsDeeXhc01hgwTGp/n5+y0tGvFCRQjZhjgrhntLZnjxDzfbT" crossorigin="anonymous">
    </script>
</body>

</html><?php /**PATH /var/www/vhosts/cloudsatllc.com/portal.cloudsatllc.com/resources/views/reportes/pdf/reporte_cobranzas.blade.php ENDPATH**/ ?>