<?php
$empresas_route = 'empresas.index';
$proveedor_route = 'proveedores.index';
$clientes_route = 'clientes.index';

$entidades = ['empresas', 'proveedores', 'clientes'];

$menu_empresas_routes = [$empresas_route, $proveedor_route, $clientes_route];
?>

<li class="nav-item dropdown">
    <a class="<?php echo \Illuminate\Support\Arr::toCssClasses([ 'nav-link' , 'active'=> Str::contains(Route::currentRouteName(), $entidades)]); ?>" href="#empresaCollapse"
        data-bs-toggle="collapse" role="button"
        aria-controls="empresaCollapse">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="nav-link-icon" height="18" width="18">
            <path class="a" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                stroke-width="1.5"
                d="M9.75,15.937c0,.932,1.007,1.688,2.25,1.688s2.25-.756,2.25-1.688S13.243,14.25,12,14.25s-2.25-.756-2.25-1.688,1.007-1.687,2.25-1.687,2.25.755,2.25,1.687" />
            <line class="a" x1="12" y1="9.75" x2="12" y2="10.875" />
            <line class="a" x1="12" y1="17.625" x2="12" y2="18.75" />
            <rect class="a" x="1.5" y="6.75" width="21" height="15" rx="1.5" ry="1.5" />
            <path class="a" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                stroke-width="1.5"
                d="M15.342,3.275A1.5,1.5,0,0,0,13.919,2.25H10.081A1.5,1.5,0,0,0,8.658,3.275L7.5,6.75h9Z" />
        </svg>
        <span>Menú Clientes</span>
    </a>
    <div class="<?php echo e(Str::contains(Route::currentRouteName(), $entidades) ? 'collapse show' : 'collapse'); ?>"
        id="empresaCollapse">
        <ul class="nav flex-column">
            
            <li class="nav-item">
                <a href="<?php echo e(route($proveedor_route)); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-link', 'active'=>
                    Str::contains(Route::currentRouteName(), 'proveedores')]); ?>">
                    <span>Proveedor</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="<?php echo e(route($clientes_route)); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-link', 'active'=>
                    Str::contains(Route::currentRouteName(), 'clientes')]); ?>">
                    <span>Clientes</span>
                </a>
            </li>
        </ul>
    </div>
</li><?php /**PATH /var/www/vhosts/cloudsatllc.com/portal.cloudsatllc.com/resources/views/layouts/sidebar/items/clientes.blade.php ENDPATH**/ ?>