<!-- NAVIGATION -->
<nav id="mainNavbar" class="navbar navbar-vertical navbar-expand-lg scrollbar bg-dark navbar-dark">

    <!-- Theme configuration (navbar) -->
    <script>
        let navigationColor = localStorage.getItem('navigationColor'),
            navbar = document.getElementById('mainNavbar');

        if (navigationColor != null && navbar != null) {
            if (navigationColor == 'inverted') {
                navbar.classList.add('bg-dark', 'navbar-dark');
                navbar.classList.remove('bg-white', 'navbar-light');
            } else {
                navbar.classList.add('bg-white', 'navbar-light');
                navbar.classList.remove('bg-dark', 'navbar-dark');
            }
        }
    </script>

    <div class="container-fluid">
        <!-- Brand -->
        <a class="mb-5 d-flex justify-content-center " href="<?php echo e(route('dashboard')); ?>">
            <img src="<?php echo e(get_logo_sistema()); ?>" class="navbar-brand-img logo-light logo-dark logo-large " alt="..."
                width="160" height="50">
        </a>

        <!-- Navbar toggler -->
        <a href="javascript: void(0);" class="navbar-toggler" data-bs-toggle="collapse"
            data-bs-target="#sidenavCollapse" aria-controls="sidenavCollapse" aria-expanded="false"
            aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </a>

        <!-- Collapse -->
        <div class="collapse navbar-collapse" id="sidenavCollapse">

            <!-- Navigation -->
            <ul class="navbar-nav mb-lg-7">
                
                <li class="nav-item">
                    <a class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-link', 'active'=>
                        is_current_route(['dashboard'])]); ?>" href="<?php echo e(route('dashboard')); ?>">
                        <svg class="nav-link-icon" viewBox="0 0 24 24" height="20" width="20"
                            xmlns="http://www.w3.org/2000/svg">
                            <defs>
                                <style>
                                    .a {
                                        fill: none;
                                        stroke: currentColor;
                                        stroke-linecap: round;
                                        stroke-linejoin: round;
                                        stroke-width: 1.5px;
                                    }
                                </style>
                            </defs>
                            <path d="M3.753,13.944v8.25h6v-6a1.5,1.5,0,0,1,1.5-1.5h1.5a1.5,1.5,0,0,1,1.5,1.5v6h6v-8.25"
                                fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                stroke-width="1.5" />
                            <path d="M.753,12.444,10.942,2.255a1.5,1.5,0,0,1,2.122,0L23.253,12.444" fill="none"
                                stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                stroke-width="1.5" />
                        </svg>
                        <span>Inicio</span>
                    </a>
                </li>
                <li class="nav-item w-100">
                    <hr>
                </li>

                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('personas_module')): ?>
                <?php echo $__env->make('layouts.sidebar.items.personas', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('clientes_module')): ?>
                <?php echo $__env->make('layouts.sidebar.items.clientes', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('mikrotik_module')): ?>
                <?php echo $__env->make('layouts.sidebar.items.mikrotiks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('remota_satelital_module')): ?>
                <?php echo $__env->make('layouts.sidebar.items.remotas', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cobranzas_module')): ?>
                <?php echo $__env->make('layouts.sidebar.items.cobranzas', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>


                <li class="nav-item w-100 ">
                    <hr>
                </li>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('administrador_module')): ?>
                <?php echo $__env->make('layouts.sidebar.items.configuracion', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

            </ul>
            <div class="text-center text-secondary ">
                <span>
                    <?php
                    $today = date('d/m/Y H:m:s'); // current year, month and day
                    $message = 'The current date is: ' . $today;
                    echo $today;
                    ?>

                </span>

            </div>

            <!-- End of Navigation -->

        </div>
        <!-- End of Collapse -->
    </div>
</nav><?php /**PATH /var/www/vhosts/cloudsatllc.com/portal.cloudsatllc.com/resources/views/layouts/sidebar/index.blade.php ENDPATH**/ ?>